/* ---------------------------------------------------------------------
Global Js
Target Browsers: All
------------------------------------------------------------------------ */

var JR = (function(JR, $) {

    $(function() {
		$( '.codedropz-btn-wrap' ).html( '<span class="cd-upload-btn">Explorar Archivos</span>' );
		$( '.cd-upload-btn' ).on('click', function () {
			$( "#file-attachment" ).click();
		});
		
		$(document).ready(function() {
			$('.content-consent-details').hide();
			$('.consentform').on('click', function() {
				var $details = $('.content-consent-details');
				$details.toggle();
				
				if ($details.is(':visible')) {
					$(this).html('<img src="https://www.cabitv.com/wp-content/uploads/cabitv-yellow-arrow-down.webp" ' + ' alt="Arrow down"> Hide Information');
					$('html, body').animate({
						scrollTop: $details.offset().top - ($(window).height() / 6)
					}, 800);
				} else {
					$(this).html(
						'<img src="https://www.cabitv.com/wp-content/uploads/cabitv-yellow-arrow-right.webp" ' + ' alt="Arrow right"> Click here for more information');
				}
			});
		});	
		/*--- Confirm Email Input ---*/
		$( 'input[name="client-email-confirm"]' ).on('paste', function(e){
            e.preventDefault();
        });
		
		/*--- Lowercase Email Input ---*/
		$('form').on('submit', function() {
			$(this).find('input[type="email"]').each(function() {
				var value = $(this).val();
				$(this).val(value.toLowerCase());
			});
		});
		
		/*--- Hidden Fields Function ---*/
		$( "#country" ).on('change', function () {
			$val = this.value;
			$( "input#hiddencountry" ).val( $val );
		});
	});
		
    return JR;
}(JR || {}, jQuery));


