<?php
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );
function my_theme_enqueue_styles() {
	wp_enqueue_style( 'child-style',
		get_stylesheet_uri(),
		array( 'parenthandle' ),
		wp_get_theme()->get( 'Version' ) // This only works if you have Version defined in the style header.
	);
}

function twentysixteen_scripts() {
	wp_enqueue_style('default', '/wp-content/themes/twentysixteen-child/assets/css/default.css', false );
	wp_enqueue_style('custom', '/wp-content/themes/twentysixteen-child/assets/css/style.css', false );
	if(is_page( 'solicitar-cotizacion' )): wp_enqueue_style( 'quote', '/wp-content/themes/twentysixteen-child/assets/css/quote.css', false ); endif;
	
	wp_enqueue_script( 'default', '/wp-content/themes/twentysixteen-child/assets/js/jquery.min.js', array(), false, true );
	if(is_page( 'solicitar-cotizacion' )): wp_enqueue_script( 'quote', '/wp-content/themes/twentysixteen-child/assets/js/quote.js', array(), false, true ); endif;
	if(is_page( 'ct200' )): wp_enqueue_script( 'slick', '/wp-content/themes/twentysixteen-child/assets/js/slick.js', array(), false, true ); endif;
	wp_enqueue_script( 'custom', '/wp-content/themes/twentysixteen-child/assets/js/main.js', array(), false, true );
}

function dm_remove_wp_block_library_css(){
	wp_dequeue_style( 'wp-block-library' );
}
add_action( 'wp_enqueue_scripts', 'dm_remove_wp_block_library_css' );

function home_redirect() {
    if( is_page('kitchen-tv')){
        wp_redirect( 'https://cabitv.com/' );
        exit();
    }
}
add_action( 'template_redirect', 'home_redirect' );

function add_shortcode_image_radio(){
    wpcf7_add_form_tag('imageradio','imageradio_handler',true);
    wpcf7_add_form_tag('imagecheckbox','imagecheckbox_handler',true);
    wpcf7_add_form_tag('grpnumber','grpnumber_handler',true);
    wpcf7_add_form_tag('grpselect','grpselect_handler',true);
    wpcf7_add_form_tag('grpradio','grpradio_handler',true);
    wpcf7_add_form_tag('imagepicker','imagepicker_handler',true);
    wpcf7_add_form_tag('defradio', 'default_radio_handler', true);
}
add_action('wpcf7_init','add_shortcode_image_radio');

function grpnumber_handler($tag){
    $tag = new WPCF7_FormTag($tag);
    $tagname = $tag->name;

    $formtag = '<span class="wpcf-form-control-wrap control-'.$tagname.'"><input type="number" name="'.$tagname.'" id="'.$tagname.'"  value="';
	$formtag .= '" class="wpcf7-form-control wpcf7-validates-as-required wpcf7-validates-as-number form-control" aria-required="true" min="0.00" aria-invalid="false" step="1"></span>';

    return $formtag;
}

function grpselect_handler($tag){
    $tag = new WPCF7_FormTag($tag);
    $tagname = $tag->name;
    $formtag = '';
    $formtag .= '<span class="wpcf7-form-control-wrap '.$tagname.'"><select name="'.$tagname.'" id="'.$tagname.'" class="'.$tagname.'-multiple wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false">';
    foreach($tag->values as $val){
        $formtag .= '<option value="'.$val.'">'.$val.'</option>';
    }
    $formtag .= '</select><label class="'.$tagname.'-label hidden-label"></label></span>';
    return $formtag;
}

function imageradio_handler($tag){
    $tag = new WPCF7_FormTag( $tag );
    $atts = array(
        'type' => 'radio',
        'name' => $tag->name,
        'list' => $tag->name . '-options'
    );
    $input = sprintf('<input %s />',wpcf7_format_atts( $atts ) );
    
    $datalist = '';
    $datalist .= '<div class="wpcf7-form-control-wrap control-'.$tag->name.'"><div class="imgradio-container quote-'.$tag->name.'">';
    foreach ( $tag->values as $val ) {
        $val_array = explode("!", $val);
        $radiovalue = "";
        $caption = "";
        if(isset($val_array[0]) && !empty($val_array[0])){
            $radiovalue = $val_array[0];
        }
        $imagepath = "";
        if(isset($val_array[1]) && !empty($val_array[1])){
            $imagepath = $val_array[1];
        }
        $default = false;
        if(isset($val_array[2]) && !empty($val_array[2])){
            $default = true;
        }
		$alt = "";
        if(isset($val_array[3]) && !empty($val_array[3])){
            $alt = $val_array[3];
        }
        $rid = uniqid();
        $datalist .= '<div class="imgradio"><input type="radio" ';
        if($default){ $datalist .= 'checked="checked"'; }
        
		$datalist .= ' name="'.$tag->name.'" value="'.$radiovalue.'" id="imgrad-' .$rid. '"/><label for="imgrad-'.$rid.'"><div><img src="'.$imagepath.'" alt="'.$alt.'" loading="lazy"></div><span>'.$radiovalue.'</span></label></div>';

    }
    $datalist .= '</div></div>';
    return $datalist;
}

function is_category_to_custom_404(){
  if( is_category() ) {
    global $wp_query;
    $wp_query->set_404();
  }
}
add_action('template_redirect', 'is_category_to_custom_404');

function is_author_to_custom_404(){
  if( is_author() ) {
    global $wp_query;
    $wp_query->set_404();
  }
}
add_action('template_redirect', 'is_author_to_custom_404');

add_filter('wpcf7_posted_data', function($posted_data) {
    if (!is_array($posted_data)) return $posted_data;

    // Lowercase specific fields by their names (from your form)
    if (isset($posted_data['client-email'])) {
        $posted_data['client-email'] = strtolower($posted_data['client-email']);
    }

    return $posted_data;
});
// Confirm Email Validation
add_filter( 'wpcf7_validate_email*', 'custom_email_confirmation_validation_filter', 20, 2 );
function custom_email_confirmation_validation_filter( $result, $tag ) {
    if ( 'client-email-confirm' == $tag->name ) {
		$your_email = isset( $_POST['client-email'] ) ? strtolower(trim( $_POST['client-email'] )) : '';
		$your_email_confirm = isset( $_POST['client-email-confirm'] ) ? strtolower(trim( $_POST['client-email-confirm'] )) : '';

		//check if matched
        if ( $your_email != $your_email_confirm ) {
            $result->invalidate( $tag, "No coincide con tu correo electrónico." );
        }
    }
    return $result;
}

add_filter( 'wpcf7_validate_text*', 'custom_zipcode_validation', 10, 2 );
function custom_zipcode_validation( $result, $tag ) {
    $name = $tag->name;

    if ( $name === 'zipcode' ) {
        $zipcode = isset( $_POST[$name] ) ? sanitize_text_field( $_POST[$name] ) : '';
		
		if ( strlen( $zipcode ) < 4 ) {
			 $result->invalidate( $tag, 'El código postal debe tener al menos 4 caracteres.' );
		}else{
			if ( preg_match( '/[^A-Za-z0-9-]/', $zipcode ) ) {
				$result->invalidate( $tag, 'Solo se permiten letras, números y guiones en el código postal (sin espacios).' );
			}elseif ( preg_match( '/^0+(-0+)?$/', $zipcode ) ) {
				$result->invalidate( $tag, 'Por favor, ingrese un código postal válido.' );
			}
		}
    }

    return $result;
}