/* ---------------------------------------------------------------------
Global Js
Target Browsers: All
------------------------------------------------------------------------ */

var JR = (function(JR, $) {

    $(function() {
        
        $( '.codedropz-btn-wrap' ).html( '<span class="cd-upload-btn">Explorar Archivos</span>' );
        $( '.cd-upload-btn' ).on('click', function () {
            $( "#file-attachment" ).click();
        });
        
        /*--- Reset Button ---*/
        $( 'input[type="reset"]' ).on('click', function(e){
            window.location.href = 'https://evervue.com.pa/myqaio/request-quote/';
        });

        /*--- Form - Invalid ---*/
        document.addEventListener( 'wpcf7invalid', function( event ) {
            $( '.rq-popup-content' ).html( '<p class="rq-title">¡Algunos campos son obligatorios!</p><p class="rq-desc">Por favor, verifique todos los campos obligatorios.</p><span class="rq-btn">De acuerdo</span>' );
            $( '.rq-popup-main' ).show();
            $( '.rq-btn' ).on('click', function() {
                $( '.rq-popup-main' ).hide();
                $('html, body').animate({
                    scrollTop: $('.gohere').offset().top - 75,
                }, 500, 'linear');
            });
        });
        
        /*--- Accessories ---*/
        $('input:checkbox[name="addons[]"]').change(function() {
            if ($(this).val() === "Ninguno" && $(this).is(':checked')) {
                // Uncheck all other checkboxes when "None" is checked
                $('input:checkbox[name="addons[]"]').not(this).prop('checked', false);
            } else {
                $('input:checkbox[name="addons[]"][value="Ninguno"]').prop('checked', false);
            }
            if ($('input:checkbox[name="addons[]"]:checked').length === 0) {
                $('input:checkbox[name="addons[]"][value="Ninguno"]').prop('checked', true);
            }
        });

        /*--- QAIO Flex Size ---*/
        $('input:radio[name="qaio-flex-size"]').change(function() {
            $own = this.value;
            $('input:radio[name="qaio-flex-mount"][value="Wall Mount"]').prop("checked", true);
            if($own == 'Limitless'){
                $('input:radio[name="qaio-flex-mount"][value="Lean On Mount"]').parent().hide();
                $('input:radio[name="qaio-flex-mount"][value="Stand Alone Mount"]').parent().hide();
            }else{
                $('input:radio[name="qaio-flex-mount"][value="Lean On Mount"]').parent().show();
                $('input:radio[name="qaio-flex-mount"][value="Stand Alone Mount"]').parent().show();
            }
        });

        /*--- Form - Success ---*/
        document.addEventListener( 'wpcf7mailsent', function( event ) {
            $( '.rq-popup-content' ).html( '<p class="rq-title">Gracias</p><p class="rq-desc">Hemos enviado un correo electrónico con el resumen de su solicitud. Nos pondremos en contacto con usted muy pronto.</p><span class="rq-btn">Cerrar</span>' );
            $( '.rq-popup-main' ).show();
            $( '.rq-btn' ).on('click', function() {
                window.location.href = 'https://evervue.com.pa/myqaio/request-quote/';
            });
        });
        
        $( '.plus' ).on('click', function () {
            $val = $( 'input[name="qty"]' ).val();
            $val++;
            $( 'input[name="qty"]' ).val($val);
        });
        
        $( '.minus' ).on('click', function () {
            $val = $( 'input[name="qty"]' ).val();
            if($val > 1){
                $val--;
                $( 'input[name="qty"]' ).val($val);
            }
        });
        
        $('input[name="qty"]').on('change', function () {
            $val = $( 'input[name="qty"]' ).val();
            if($val < 1 || $val == ''){
               $( 'input[name="qty"]' ).val(1);
            }
        });
    /*--- Consent Details ---*/
        $(document).ready(function() {
            $('.content-consent-details').hide();
            $('.consentform').on('click', function() {
                var $details = $('.content-consent-details');
                $details.toggle();
                
                if ($details.is(':visible')) {
                    $(this).html('<img src="https://www.myqaio.com/wp-content/uploads/blue-arrow-down.webp" ' + ' alt="Arrow down"> Hide Information');
                    $('html, body').animate({
                        scrollTop: $details.offset().top - ($(window).height() / 6)
                    }, 800);
                } else {
                    $(this).html(
                        '<img src="https://www.myqaio.com/wp-content/uploads/blue-arrow-down.webp" ' + ' alt="Arrow right"> Click here for more information');
                }
            });
        }); 

        /*--- Consent Pop ---*/
        $cs = 1;
        $( '.showpop' ).on( 'click', function() {
            $( '.pop-info-opacity' ).fadeIn( 300 );
        });
        $( '.pop-info-center' ).on('mouseenter', function() {
            $cs = 0;
        });
        $( '.pop-info-center' ).on('mouseleave', function() {
            $cs = 1;
        });
        $( '.pop-info-flex' ).on('click', function() {
            if( $cs == 1 ){ $( '.pop-info-opacity' ).fadeOut( 300 ); }
        }); 
        
        /*--- Add New Mirror ---*/
        $newmirror = '';
        $idcnt = 1;
        $( '.add-new-mirror-size' ).on('click', function() {
            $newmirrorshape = $( 'input:radio[name="qaio-shape"]:checked' ).val();
            $globalunit = $( '#width-unit option:selected' ).text();
            $mirrorcnt = $('.sortable-span').length;
            $inputcnt = $mirrorcnt + 1;
            $mirrorcnt = $mirrorcnt + 2;
            
            $idcnt++;
            $newmirror += '<div class="new-mirror-container anm-div">';

                $newmirror +='<div class="specifications-container specs-container anm-div">';
                    $newmirror += '<div class="sortable-container"><span class="sortable-span">Especificaciones del Espejo '+$mirrorcnt+'</span><img class="img-responsive close-mirror" src="https://www.mirrorvue.com/wp-content/uploads/black-close.webp" alt="Mirror Close icon."></div>';
                    $newmirror += '<div class="anm-div">';
                        $newmirror += '<span class="specs-title">Tamaño del cristal del espejo:</span>';
                        $newmirror += '<div class="specifications-col">';
                            $newmirror += '<div class="form-group">';
                                $newmirror += '<label for="width['+$idcnt+']" aria-label="width">Ancho:</label>';
                                $newmirror += '<span class="wpcf-form-control-wrap control-width"><input type="number" name="width[]" id="width['+$idcnt+']" class="wpcf7-form-control wpcf7-validates-as-required wpcf7-validates-as-number form-control" value="1" min="1" aria-required="true" aria-invalid="false"></span>';
                                $newmirror += '<span class="wpcf7-form-control-wrap width-unit">';
                                    if($globalunit == 'inches'){
                                        $newmirror += '<select name="width-unit[]" id="width-unit['+$idcnt+']" class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false"><option value="mm">mm</option><option value="inches" selected>inches</option></select>'; 
                                    }else{
                                        $newmirror += '<select name="width-unit[]" id="width-unit['+$idcnt+']" class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false"><option value="mm" selected>mm</option><option value="inches">inches</option></select>';    
                                    }
                                $newmirror += '</span>';
                            $newmirror += '</div>';
                            $newmirror += '<div class="form-group">';
                                $newmirror += '<label for="height['+$idcnt+']" aria-label="height">Altura:</label>';
                                $newmirror += '<span class="wpcf-form-control-wrap control-height"><input type="number" name="height[]" id="height['+$idcnt+']" class="wpcf7-form-control wpcf7-validates-as-required wpcf7-validates-as-number form-control" value="1" min="1" aria-required="true" aria-invalid="false"></span>';
                                $newmirror += '<span class="wpcf7-form-control-wrap height-unit">';
                                    if($globalunit == 'inches'){
                                        $newmirror += '<select name="height-unit[]" id="height-unit['+$idcnt+']" class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false"><option value="mm">mm</option><option value="inches" selected>inches</option></select>';
                                    }else{
                                        $newmirror += '<select name="height-unit[]" id="height-unit['+$idcnt+']" class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false"><option value="mm" selected>mm</option><option value="inches">inches</option></select>';
                                    }
                                $newmirror += '</span>';
                            $newmirror += '</div>';
                        $newmirror += '</div>';
                        $newmirror += '<div class="specifications-col">';
                            $newmirror += '<div class="form-group2">';
                                if($newmirrorshape == 'Rectangular' || $newmirrorshape == 'Forma Personalizada'){
                                    $newmirror += '<div data-id="group-number-led" data-orig_data_id="group-number-led" data-class="wpcf7cf_group" style="height: auto; display: block;" class="qaio-num-led">';
                                }else{
                                    $newmirror += '<div data-id="group-number-led" data-orig_data_id="group-number-led" data-class="wpcf7cf_group" style="height: auto; display: none;" class="wpcf7cf-hidden qaio-num-led">';
                                }
                                    $newmirror += '<label for="number-led['+$idcnt+']" aria-label="Number of LED Light Bars">Número de barras de luz LED:</label>';
                                    $newmirror += '<span class="wpcf-form-control-wrap control-number-led"><input type="number" name="number-led[]" id="number-led['+$idcnt+']" class="wpcf7-form-control wpcf7-validates-as-required wpcf7-validates-as-number form-control" value="1" min="1" aria-required="true" aria-invalid="false"></span>';
                                $newmirror += '</div>';
                            $newmirror += '</div>';
                        $newmirror += '</div>';
                    $newmirror += '</div>';
                $newmirror += '</div>';

                $newmirror +='<div class="tv-size-container anm-div text-center">';
                    $newmirror += '<label class="specs-title" for="tv-size['+$idcnt+']" aria-label="Select TV Size">Elige el tamaño del televisor:</label>';
                    $newmirror += '<span class="wpcf7-form-control-wrap">';
                        $newmirror += '<select class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" id="tv-size['+$idcnt+']" aria-required="true" aria-invalid="false" name="tv-size[]">';
                            $newmirror += '<option value="15.6&quot; Water-resistant LED TV (12V) (720p)">15.6" Water-resistant LED TV (12V) (720p)</option>';
                            $newmirror += '<option value="22&quot; Water-resistant LED TV (12V) (Full HD)">22" Water-resistant LED TV (12V) (Full HD)</option>';
                            $newmirror += '<option value="28&quot; Water-resistant LED TV (24V) (4K)">28" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="32&quot; Water-resistant LED TV (24V) (4K)">32" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="40&quot; Water-resistant LED TV (24V) (4K)">40" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="50&quot; Water-resistant LED TV (24V) (4K)">50" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="55&quot; Water-resistant OLED TV (24V) (4K)">55" Water-resistant OLED TV (24V) (4K)</option>';
                            $newmirror += '<option value="60&quot; Water-resistant LED TV (24V) (4K)">60" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="65&quot; Water-resistant OLED TV (24V) (4K)">65" Water-resistant OLED TV (24V) (4K)</option>';
                            $newmirror += '<option value="75&quot; Water-resistant LED TV (24V) (4K)">75" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="85&quot; Water-resistant LED TV (24V) (4K)">85" Water-resistant LED TV (24V) (4K)</option>';
                            $newmirror += '<option value="100&quot; Water-resistant LED TV (24V) (4K)">100" Water-resistant LED TV (24V) (4K)</option>';
                        $newmirror += '</select>';
                    $newmirror += '</span>';
                $newmirror += '</div>';
            
                $newmirror +='<div class="specifications-container anm-div">';
                    $newmirror += '<span class="specs-title">Elige la ubicación principal del televisor:</span>';
                    $newmirror +='<div class="wpcf7-form-control-wrap remove-prev-next control-led-tv">';
                        $newmirror +='<div class="imgradio-container quote-led-tv">';
                            $newmirror += '<div class="imgradio"><input type="radio" checked="checked" name="led-tv['+$inputcnt+']" value="Centro" id="led-tv100['+$idcnt+']"><label for="led-tv100['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-center.webp" alt="An icon representing a television located at the center."></div><span>Centro</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Centro superior" id="led-tv200['+$idcnt+']"><label for="led-tv200['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-top-center.webp" alt="An icon representing a television located at the top center."></div><span>Centro superior</span></label></div>';this
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Centro inferior" id="led-tv300['+$idcnt+']"><label for="led-tv300['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-bottom-center.webp" alt="An icon representing a television located at the bottom center."></div><span>Centro inferior</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Izquierda" id="led-tv400['+$idcnt+']"><label for="led-tv400['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-middle-left.webp" alt="An icon representing a television located at the middle left."></div><span>Izquierda</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Superior izquierda" id="led-tv500['+$idcnt+']"><label for="led-tv500['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-top-left.webp" alt="An icon representing a television located at the top left."></div><span>Superior izquierda</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Inferior izquierda" id="led-tv600['+$idcnt+']"><label for="led-tv600['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-bottom-left.webp" alt="An icon representing a television located at the bottom left."></div><span>Inferior izquierda</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Derecha" id="led-tv700['+$idcnt+']"><label for="led-tv700['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-middle-right.webp" alt="An icon representing a television located at the middle right."></div><span>Derecha</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Superior derecha" id="led-tv800['+$idcnt+']"><label for="led-tv800['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-top-right.webp" alt="An icon representing a television located at the top right."></div><span>Superior derecha</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv['+$inputcnt+']" value="Inferior derecha" id="led-tv900['+$idcnt+']"><label for="led-tv900['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/main-tv-bottom-right.webp" alt="An icon representing a television located at the bottom right."></div><span>Inferior derecha</span></label></div>';
                        $newmirror += '</div>';
                    $newmirror += '</div>';
                $newmirror += '</div>';
            
                $newmirror +='<div class="specifications-container anm-div">';
                    $newmirror += '<span class="specs-title">Elige la ubicación del televisor de 12.1":</span>';
                    $newmirror +='<div class="wpcf7-form-control-wrap remove-prev-next control-led-tv2">';
                        $newmirror +='<div class="imgradio-container quote-led-tv2">';
                            $newmirror += '<div class="imgradio"><input type="radio" checked="checked" name="led-tv2['+$inputcnt+']" value="Center" id="led-tv2100['+$idcnt+']"><label for="led-tv2100['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-center.webp" alt="A small icon representing a television located at the center."></div><span>Center</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Top Center" id="led-tv2200['+$idcnt+']"><label for="led-tv2200['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-top-center.webp" alt="A small icon representing a television located at the top center."></div><span>Top Center</span></label></div>';this
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Bottom Center" id="led-tv2300['+$idcnt+']"><label for="led-tv2300['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-bottom-center.webp" alt="A small icon representing a television located at the bottom center."></div><span>Bottom Center</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Left" id="led-tv2400['+$idcnt+']"><label for="led-tv2400['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-middle-left.webp" alt="A small icon representing a television located at the middle left."></div><span>Left</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Top Left" id="led-tv2500['+$idcnt+']"><label for="led-tv2500['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-top-left.webp" alt="A small icon representing a television located at the top left."></div><span>Top Left</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Bottom Left" id="led-tv2600['+$idcnt+']"><label for="led-tv2600['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-bottom-left.webp" alt="A small icon representing a television located at the bottom left."></div><span>Bottom Left</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Right" id="led-tv2700['+$idcnt+']"><label for="led-tv2700['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-middle-right.webp" alt="A small icon representing a television located at the middle right."></div><span>Right</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Top Right" id="led-tv2800['+$idcnt+']"><label for="led-tv2800['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-top-right.webp" alt="A small icon representing a television located at the top right."></div><span>Top Right</span></label></div>';
                            $newmirror += '<div class="imgradio"><input type="radio" name="led-tv2['+$inputcnt+']" value="Bottom Right" id="led-tv2900['+$idcnt+']"><label for="led-tv2900['+$idcnt+']"><div><img src="/myqaio/wp-content/uploads/small-tv-bottom-right.webp" alt="A small icon representing a television located at the bottom right."></div><span>Bottom Right</span></label></div>';
                        $newmirror += '</div>';
                    $newmirror += '</div>';
                $newmirror += '</div>';
            
                $newmirror +='<div class="request-quote-container specifications-container anm-div text-center">';
                    $newmirror += '<label class="specs-title" for="quantity['+$idcnt+']" aria-label="Quantity of Order">Cantidad del pedido:</label>';
                    $newmirror += '<span class="wpcf-form-control-wrap control-quantity"><input type="number" name="quantity[]" value="1" id="quantity['+$idcnt+']" class="wpcf7-form-control wpcf7-validates-as-required wpcf7-validates-as-number form-control" min="1" aria-required="true" aria-invalid="false"></span>';
                $newmirror += '</div>';

            $newmirror +='</div>';
            
            $( '.anm-container' ).append( $newmirror );
            $newmirror = '';
            
            /*--- Remove Mirror ---*/
            $( '.close-mirror' ).on('click', function() {
                $( this ).parent().parent().parent().remove();
                $( '.sortable-span' ).each(function(n){
                    n = n + 2;
                    $( this ).html('Especificaciones del Espejo '+n);
                });
            });
            
            /*--- Show/Hide Number LED Light Bars ---*/
            $( 'input:radio[name="qaio-shape"]' ).on('change', function () {
                $val = this.value;
                if($val == 'Rectangular' || $val == 'Forma Personalizada'){
                    setTimeout(function() {
                        $( '.qaio-num-led' ).css( "display", "block" );
                        $( '.qaio-num-led' ).removeClass( "wpcf7cf-hidden" );
                    }, 100);
                }else{
                    setTimeout(function() {
                        $( '.qaio-num-led' ).css( "display", "none" );
                        $( '.qaio-num-led' ).addClass( "wpcf7cf-hidden" );
                    }, 100);
                }
            });
            
            myFunction.init();
            
        });
        
        myFunction.init();
  
    });
    
    var myFunction = (function() {

        var that = {};
        that.init = function () {

            /*--- Specification Unit Change ---*/
            $( 'select[name="width-unit[]"], select[name="height-unit[]"]' ).on('change', function() {
                $val = $(this).val();
                $( '.rq-form' ).find('select[name="width-unit[]"]').val($val);
                $( '.rq-form' ).find('select[name="height-unit[]"]').val($val);
            });

        }

        return that;

    })();
	
		/*--- Confirm Email Input ---*/
		$( 'input[name="client-email-confirm"]' ).on('paste', function(e){
            e.preventDefault();
        });
		/*--- Lowercase Email Input ---*/
        $('form').on('submit', function() {
            $(this).find('input[type="client-email"]').each(function() {
                var value = $(this).val();
                $(this).val(value.toLowerCase());
            });
        });	
		/*--- Hidden Fields Function ---*/
		$( "#country" ).on('change', function () {
			$val = this.value;
			$( "input#hiddencountry" ).val( $val );
		});
        
    return JR;
}(JR || {}, jQuery));


