<?php
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );
function my_theme_enqueue_styles() {
	wp_enqueue_style( 'child-style',
		get_stylesheet_uri(),
		array( 'parenthandle' ),
		wp_get_theme()->get( 'Version' ) // This only works if you have Version defined in the style header.
	);
}

function dm_remove_wp_block_library_css(){
	wp_dequeue_style( 'wp-block-library' );
	
	if(!is_page('request-quote')):
		wp_deregister_script( 'codedropz-uploader' );
		wp_deregister_script( 'contact-form-7' );
		wp_deregister_script( 'wpcf7cf-scripts' );
		wp_deregister_script( 'jquery-migrate' );
		wp_deregister_script( 'jquery-core' );
	
		wp_deregister_style( 'contact-form-7' );
		wp_deregister_style( 'dnd-upload-cf7' );
		wp_deregister_style( 'cf7cf-style' );
	endif;
}
add_action( 'wp_enqueue_scripts', 'dm_remove_wp_block_library_css', 99 );

function twentysixteen_scripts() {
	wp_enqueue_style('default', '/wp-content/themes/twentysixteen-child/assets/css/default.css', false );
	wp_enqueue_style('custom', '/wp-content/themes/twentysixteen-child/assets/css/style.css', false );
	if(is_page( 'request-quote' )): wp_enqueue_style( 'quote', '/wp-content/themes/twentysixteen-child/assets/css/quote.css', false ); endif;
	
	wp_enqueue_script( 'default', '/wp-content/themes/twentysixteen-child/assets/js/jquery.min.js', array(), false, true );
	if(is_page( 'request-quote' )): wp_enqueue_script( 'quote', '/wp-content/themes/twentysixteen-child/assets/js/quote.js', array(), false, true ); endif;
	wp_enqueue_script( 'custom', '/wp-content/themes/twentysixteen-child/assets/js/main.js', array(), false, true );
}

function add_shortcode_image_radio(){
    wpcf7_add_form_tag('imageradio','imageradio_handler',true);
    wpcf7_add_form_tag('imagecheckbox','imagecheckbox_handler',true);
    wpcf7_add_form_tag('grpnumber','grpnumber_handler',true);
    wpcf7_add_form_tag('grpselect','grpselect_handler',true);
    wpcf7_add_form_tag('grpradio','grpradio_handler',true);
    wpcf7_add_form_tag('imagepicker','imagepicker_handler',true);
	wpcf7_add_form_tag('defradio', 'default_radio_handler', true);
}
add_action('wpcf7_init','add_shortcode_image_radio');

function grpnumber_handler($tag){
    $tag = new WPCF7_FormTag($tag);
    $tagname = $tag->name;
    if($tagname == 'width' || $tagname == 'height' || $tagname == 'quantity' || $tagname == 'number-led'):
        $formtag = '<span class="wpcf-form-control-wrap control-'.$tagname.'"><input type="number" name="'.$tagname.'[]" id="'.$tagname.'"  value="';
    else:
        $formtag = '<span class="wpcf-form-control-wrap control-'.$tagname.'"><input type="number" name="'.$tagname.'" id="'.$tagname.'"  value="';
    endif;
    if(isset($tag->values[0]) && !empty($tag->values[0])){
        $formtag .= $tag->values[0];
    }
    $formtag .= '" class="wpcf7-form-control wpcf7-validates-as-required wpcf7-validates-as-number form-control" min="1" aria-required="true" aria-invalid="false"></span>';
    return $formtag;
}

function grpselect_handler($tag){
    $tag = new WPCF7_FormTag($tag);
    $tagname = $tag->name;
    $formtag = '';
    if($tagname == 'width-unit' || $tagname == 'height-unit' || $tagname == 'tv-size'):
        $formtag .= '<span class="wpcf7-form-control-wrap '.$tagname.'"><select name="'.$tagname.'[]" id="'.$tagname.'" class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false">';
    else:
        $formtag .= '<span class="wpcf7-form-control-wrap '.$tagname.'"><select name="'.$tagname.'" id="'.$tagname.'" class="wpcf7-form-control wpcf7-select wpcf7-validates-as-required form-control" aria-invalid="false">';
    endif;
    foreach($tag->values as $val){
        $formtag .= '<option value="'.$val.'">'.$val.'</option>';
    }
    $formtag .= '</select></span>';
    return $formtag;
}

function imagepicker_handler($tag){
    $tag = new WPCF7_FormTag($tag);
    $formtag = '';
    $category = [];
    $img_arr = [];
    $caption_arr = [];
    $cat_arr = [];
    $name_arr = [];
    $alt_arr = [];
    $tagname = $tag->name;
    foreach ( $tag->values as $index=> $val ) {
        $val_array = explode("!", $val);
        $img_url = '';
        $alt_url = '';
        $caption = '';
        $dcat = '';
        if(isset($val_array[0]) && !empty($val_array[0])){
            $img_url = $val_array[0];
        }
        $img_arr[$index] = $img_url;

        if(isset($val_array[1]) && !empty($val_array[1])){
            $caption = $val_array[1];
        }
        $caption_arr[$index] = $caption;
        $name_arr[$caption] = $index;

        if(isset($val_array[2]) && !empty($val_array[2])){
            $dcat = $val_array[2];
            $category[] = $dcat;
        }
        $cat_arr[$index] = $dcat;
        $alt = "";
        if(isset($val_array[3]) && !empty($val_array[3])){
            $alt = $val_array[3];
        }
        $alt_arr[$index] = $alt;
    }

    $category = array_unique($category);
    sort($category);
    $formtag .= '<div class="imagepicker remove-prev-next">';
    $formtag .= '<div class="category-container"><label for="select-frame">Select a Category:</label><div class="ip-sel-cont"><select class="img-cat form-control" id="select-frame">';
    $formtag .= '<option value="all">All</option>';
    foreach($category as $cat){
        $formtag .= '<option value="'.$cat.'">'.$cat.'</option>';
    }
    $formtag .= '</select></div></div>';

    $formtag .= '<span class="wpcf7-form-control-wrap '.$tagname.'"><div class="imgpicker-list"><ul>';
    foreach($name_arr as $name => $index){
        if(!empty($img_arr[$index])){
            $rid = uniqid();
            $img_url = $img_arr[$index];
            $alt_url = $alt_arr[$index];
            $formtag .= '<li data-cat="'.$cat_arr[$index].'">';
            $formtag .= '<input type="radio" name="'.$tagname.'" value="';
            if(!empty($caption_arr[$index])){
                $formtag .= $caption_arr[$index];
            }
            $formtag .= '" id="imgp-'.$rid.'" />';
            $formtag .= '<label for="imgp-'.$rid.'"><div class="custom-request-new"><img src="'.$img_url.'" alt="'.$alt_url.'" loading="lazy"></div>';
            if(!empty($caption_arr[$index])){
                $formtag .= '<span>'.$caption_arr[$index].'</span>';
            }
            $formtag .= '</label></li>';
        }
    }
    $formtag .= '</ul></div></span>';
    $formtag .= '</div>';
    return $formtag;
}

function imageradio_handler($tag){
    $tag = new WPCF7_FormTag( $tag );
    $atts = array(
        'type' => 'radio',
        'name' => $tag->name,
        'list' => $tag->name . '-options'
	);
    $input = sprintf('<input %s />',wpcf7_format_atts( $atts ) );
	
    $datalist = '';
    $datalist .= '<div class="wpcf7-form-control-wrap remove-prev-next control-'.$tag->name.'"><div class="imgradio-container quote-'.$tag->name.'">';
    foreach ( $tag->values as $val ) {
        $val_array = explode("!", $val);
        $radiovalue = "";
		$title = "";
        $caption = "";
        if(isset($val_array[0]) && !empty($val_array[0])){
			if(isset($val_array[2]) && !empty($val_array[2])){
				$radiovalue = $val_array[0].' - '.$val_array[2];
			}else{
				$radiovalue = $val_array[0];
			}
            $title = $val_array[0];
        }
        $imagepath = "";
        if(isset($val_array[1]) && !empty($val_array[1])){
            $imagepath = $val_array[1];
        }
        if(isset($val_array[2]) && !empty($val_array[2])){
            $caption = '<span class="caption">'.$val_array[2].'</span>';
        }
        $default = false;
        if(isset($val_array[3]) && !empty($val_array[3])){
            $default = true;
        }
        $alt = "";
        if(isset($val_array[4]) && !empty($val_array[4])){
            $alt = $val_array[4];
        }
        $rid = uniqid();

        $datalist .= '<div class="imgradio"><input type="radio" ';
        if($default){ $datalist .= 'checked="checked"'; }
        if($tag->name == 'led-tv' || $tag->name == 'led-tv2'):
            $datalist .= ' name="'.$tag->name.'[0]" value="'.$radiovalue.'" id="imgrad-' .$rid. '"/><label for="imgrad-'.$rid.'"><div><img loading="lazy" src="'.$imagepath.'" alt="'.$alt.'"></div><span>'.$title.'</span>'.$caption.'</label></div>';
        else:
            $checkstring = substr($imagepath, -3);
            if($checkstring == 'mp4'):
                $datalist .= ' name="'.$tag->name.'" value="'.$radiovalue.'" id="imgrad-' .$rid. '"/><label for="imgrad-'.$rid.'"><div><video width="100%" playsinline autoplay loop muted><source src="'.$imagepath.'"></video></div><span>'.$title.'</span>'.$caption.'</label></div>';
            else:
	           $datalist .= ' name="'.$tag->name.'" value="'.$radiovalue.'" id="imgrad-' .$rid. '"/><label for="imgrad-'.$rid.'"><div><img loading="lazy" src="'.$imagepath.'" alt="'.$alt.'"></div><span>'.$title.'</span>'.$caption.'</label></div>';
            endif;
        endif;
    }
    $datalist .= '</div></div>';
    return $datalist;
}

function default_radio_handler($tag){
    $tag = new WPCF7_FormTag( $tag );
    $atts = array(
        'type' => 'radio',
        'name' => $tag->name,
        'list' => $tag->name . '-options'
    );
    $input = sprintf('<input %s />',wpcf7_format_atts( $atts ) );
    
    $datalist = '';
    $datalist .= '<div class="wpcf7-form-control-wrap remove-prev-next control-'.$tag->name.'"><div class="defaultradio-container qoute-'.$tag->name.'">';
    foreach ( $tag->values as $val ) {
        $val_array = explode("!", $val);
        $radiovalue = "";
        $caption = "";
        if(isset($val_array[0]) && !empty($val_array[0])){
            $radiovalue = $val_array[0];
        }
        $imagepath = "";
        if(isset($val_array[1]) && !empty($val_array[1])){
            $imagepath = $val_array[1];
        }
        if(isset($val_array[2]) && !empty($val_array[2])){
            $caption = '<span class="caption">'.$val_array[2].'</span>';
        }
        $default = false;
        if(isset($val_array[3]) && !empty($val_array[3])){
            $default = true;
        }
        $list = "";
        if(isset($val_array[4]) && !empty($val_array[4])){
            $list = $val_array[4];
        }
        $rid = uniqid();

        $datalist .= '<div class="defaultradio"><input type="radio" ';
        if($default){ $datalist .= 'checked="checked"'; }
        
        $datalist .= ' name="'.$tag->name.'[]" value="'.$radiovalue.'" id="imgrad-' .$rid. '"/><label for="imgrad-'.$rid.'"><span>'.$radiovalue.'</span>'.$caption.'</label></div>';
    }
    $datalist .= '</div></div>';
    return $datalist;
}

function imagecheckbox_handler($tag){
    $tag = new WPCF7_FormTag($tag);
    $name = $tag->name;
    $options = $tag->options;
    $values = $tag->values;
    $output = '';
    if(isset($values) && !empty($values)){
        $option_array = array(
            'class' => '',
            'col' => ''
        );
        foreach ($options as $key => $option) {
            foreach($option_array as $in => $val){
                $tag_pos = strpos($option, $in);
                if($tag_pos !== false && $tag_pos == 0){
                    $_in = strlen($in)+1;
                    $option_array[$in] = substr($option,$_in);
                }
            }
        }

        $output .= '<div class="wpcf7-form-control-wrap remove-prev-next control-'.$name.'">';
        $container = '<div class="imgradio-container quote-'.$name;
        if(isset($option_array['class']) && !empty($option_array['class'])){
            $container .= ' '.$option_array['class'];
        }
        $container .= '">';

        $output .= $container;
    
        foreach($values as $index => $val){
            $val_arr = explode("!", $val);
            $rid = uniqid();
            $radiovalue = '';
			$title = '';
            $img = '';
            if(isset($val_arr[0]) && !empty($val_arr[0])){
				if(isset($val_arr[2]) && !empty($val_arr[2])){
					$radiovalue = $val_arr[0].' - '.$val_arr[2];
				}else{
					$radiovalue = $val_arr[0];
				}
				$title = $val_arr[0];
            }
            $output .= '<div class="imgradio"><input type="checkbox" ';
            if(isset($val_arr[3]) && !empty($val_arr[3])) {
                $output .= 'checked="checked"';
            }
            $output .= ' name="'.$name.'[]" value="'.$radiovalue.'" id="imgcb-'.$rid.'">';
            $output .= '<label for="imgcb-'.$rid.'"><div>';
            $alt = "";
            if(isset($val_arr[4]) && !empty($val_arr[4])){
                $alt = $val_arr[4];
            }
            if(isset($val_arr[1]) && !empty($val_arr[1])){
                $output .= '<img loading="lazy" src="'.$val_arr[1].'" alt="'.$alt.'">';
            }
           
			$caption = "";
            if(isset($val_arr[2]) && !empty($val_arr[2])){
                $caption = '<span class="caption">'.$val_arr[2].'</span>';
            }
            $output .= '</div>';
			$output .= '<span>'.$title.'</span>'.$caption.'</label></div>';
        }
    $output .= '</div></div>';
    }
    return $output;
}

add_filter('wpcf7_special_mail_tags','ev_special_mail_tags',20,3);
function ev_special_mail_tags($output, $name, $html){
	$name = preg_replace('/^wpcf7\./', '_', $name);
	$submission = WPCF7_Submission::get_instance();
	$posted_data = $submission->get_posted_data();
    $selected_shape = $posted_data['qaio-shape'];
	$output = '';
	if( '_mirror_specs_grp' == $name ){
		if(isset($posted_data['width']) && !empty($posted_data['width']) && isset($posted_data['width-unit']) && !empty($posted_data['width-unit']) && isset($posted_data['height']) && !empty($posted_data['height']) && isset($posted_data['height-unit']) && !empty($posted_data['height-unit'])) {
			$width_arr = $posted_data['width'];
			$height_arr = $posted_data['height'];
			$width_unit_arr = $posted_data['width-unit'];
			$height_unit_arr = $posted_data['height-unit'];
			$quantity_arr = $posted_data['quantity'];
			$tv_size = $posted_data['tv-size'];
            $main_location = $posted_data['led-tv'];
            $secondary_location = $posted_data['led-tv2'];
            $quantity = $posted_data['quantity'];
            $num_led = $posted_data['number-led'];
			foreach($width_arr as $index => $wid){
                $count = $index+1;
                $output .= '<tr><td colspan="2">&nbsp;</td></tr>';
                $output .= '<tr><td colspan="2"><b>ESPECIFICACIÓN DEL ESPEJO QAIO '.$count.'</b></td></tr>';
				$output .= '<tr><td>Ancho:</td><td>'.$wid.' '.$width_unit_arr[$index].'</td></tr>';
				$output .= '<tr><td>Altura:</td><td>'.$height_arr[$index].' '.$height_unit_arr[$index].'</td></tr>';
                if($selected_shape == 'Rectangular' || $selected_shape == 'Forma Personalizada'): $output .= '<tr><td>Barras de Luz LED:</td><td>'.$num_led[$index].'</td></tr>'; endif;
				$output .= '<tr><td>Tamaño del Televisor:</td><td>'.$tv_size[$index].'</td></tr>';
                $output .= '<tr><td>Ubicación Principal del televisor:</td><td>'.$main_location[$index].'</td></tr>';
                $output .= '<tr><td>Ubicación del Televisor de 12.1":</td><td>'.$secondary_location[$index].'</td></tr>';
				$output .= '<tr><td>Cantidad:</td><td>'.$quantity[$index].'</td></tr>';
			}
		}
	} else if('_framename' == $name) {
		if(isset($posted_data['framedesign']) && !empty($posted_data['framedesign'])){
			$framedesign = explode(';', $posted_data['framedesign']);
			if(isset($framedesign[1]) && !empty($framedesign[1])){
				$output = $framedesign[1];
			}
		}
	}
	return $output;
}

// Lowercase Email Data
add_filter('wpcf7_posted_data', function($posted_data) {
    if (!is_array($posted_data)) return $posted_data;

    // Lowercase specific fields by their names (from your form)
    if (isset($posted_data['client-email'])) {
        $posted_data['client-email'] = strtolower($posted_data['client-email']);
    }

    return $posted_data;
});

add_filter( 'wpcf7_validate_email*', 'custom_email_confirmation_validation_filter', 20, 2 );
function custom_email_confirmation_validation_filter( $result, $tag ) {
    if ( 'client-email-confirm' == $tag->name ) {
        $your_email = isset( $_POST['client-email'] ) ? trim( $_POST['client-email'] ) : '';
        $your_email_confirm = isset( $_POST['client-email-confirm'] ) ? trim( $_POST['client-email-confirm'] ) : '';
 
        if ( $your_email != $your_email_confirm ) {
            $result->invalidate( $tag, "No coincide con tu correo electrónico." );
        }
    }
    return $result;
}

// function is_category_to_custom_404(){
//   if( is_category() ) {
//     global $wp_query;
//     $wp_query->set_404();
//   }
// }
// add_action('template_redirect', 'is_category_to_custom_404');

function is_author_to_custom_404(){
  if( is_author() ) {
    global $wp_query;
    $wp_query->set_404();
  }
}
add_action('template_redirect', 'is_author_to_custom_404');


add_filter( 'wpcf7_validate_text*', 'custom_zipcode_validation', 10, 2 );
function custom_zipcode_validation( $result, $tag ) {
    $name = $tag->name;

    if ( $name === 'zipcode' ) {
        $zipcode = isset( $_POST[$name] ) ? sanitize_text_field( $_POST[$name] ) : '';
		
		if ( strlen( $zipcode ) < 4 ) {
			 $result->invalidate( $tag, 'El código postal debe tener al menos 4 caracteres.' );
		}else{
			if ( preg_match( '/[^A-Za-z0-9-]/', $zipcode ) ) {
				$result->invalidate( $tag, 'Solo se permiten letras, números y guiones en el código postal (sin espacios).' );
			}elseif ( preg_match( '/^0+(-0+)?$/', $zipcode ) ) {
				$result->invalidate( $tag, 'Por favor, ingrese un código postal válido.' );
			}
		}
    }

    return $result;
}