<!DOCTYPE html>
<html lang="es" dir="ltr" class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <header class="page-header">
        <div class="container">
            <div class="row">
                <div class="col-xxs-12">
                    <a class="logo" href="<?php echo home_url(); ?>" aria-label="Home link"><img class="img-responsive" src="/myqaio/wp-content/uploads/qaio-logo-white.webp" alt="QAIO The Smarter Mirror logo in white."></a>
                    <div class="menu-icon not-active hidden-md-up">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                    <nav class="nav-primary">
                        <ul>
                            <li><a href="<?php the_permalink(11); ?>">QAIO Espejo</a></li>
                            <li><a href="<?php the_permalink(13); ?>">QAIO Flex</a></li>
                            <li><a href="<?php the_permalink(15); ?>">QAIO Personalizado</a></li>
                            <li class="hasachild-li">
                                <span class="hasachild"> Comercial <img class="img-responsive" src="/myqaio/wp-content/uploads/menu-arrow.webp" alt="Menu Black Arrow."></span>
                                <div class="submenu-container">
                                    <ul class="submenu">
                                        <li><a href="<?php the_permalink(17); ?>">Hospitalidad</a></li>
                                        <li><a href="<?php the_permalink(19); ?>">Distribuidores/Minoristas</a></li>
                                    </ul>
                                </div>
                            </li>
                            <li><a href="<?php the_permalink(21); ?>">Centro de Ayuda</a></li>
                            <li><a href="<?php the_permalink(23); ?>">Solicitar Cotización</a></li>
                            <li class="hasachild-li">
                                <span class="hasachild"> COMPRAR <img class="img-responsive" src="/myqaio/wp-content/uploads/menu-arrow.webp" alt="Menu Black Arrow."></span>
                                <div class="submenu-container">
                                    <ul class="submenu flagmenu">
                                        <li><a href="https://evervuestore.com/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/united-states-flag-icon.webp" alt="United States of America flag icon."> United States</a></li>
                                        <li><a href="https://www.evervue.ca/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/canada-flag-icon.webp" alt="Canada flag icon."> Canada</a></li>
                                        <li><a href="https://www.evervue.co.uk/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/united-kingdom-flag-icon.webp" alt="United Kingdom flag icon."> United Kingdom</a></li>
                                        <li><a href="https://www.evervue.nl/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/netherlands-flag-icon.webp" alt="Netherlands flag icon."> The Netherlands</a></li>
                                        <li><a href="https://www.evervue.be/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/belgium-flag-icon.webp" alt="Belgium flag icon."> Belgium</a></li>
                                        <li><a href="https://www.evervue.ae/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/united-arab-emirates-flag-icon.webp" alt="United Arab Emirates flag icon."> UAE</a></li>
                                        <li><a href="https://www.evervue.qa/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/qatar-flag-icon.webp" alt="Qatar flag icon."> Qatar</a></li>
                                        <li><a href="https://www.evervue.com.sg/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/singapore-flag-icon.webp" alt="Singapore flag icon."> Singapore</a></li>
                                        <li><a href="https://www.evervue.cn/qaio-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/china-flag-icon.webp" alt="China flag icon."> 中国 China</a></li>
                                        <li><a href="https://www.evervue.com.hk/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/hong-kong-flag-icon.webp" alt="Hong Kong flag icon."> 香港 Hong Kong</a></li>
                                        <li><a href="https://www.evervue.com.ph/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/philippine-flag-icon.webp" alt="Philippine flag icon."> Philippines</a></li>
                                        <li><a href="https://www.evervue.com.au/product-category/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/australia-flag-icon.webp" alt="Australia flag icon."> Australia</a></li>
                                        <li><a href="https://evervue.com.pa/tienda/categoria-de-producto/qaio-the-smarter-mirror/"><img class="img-responsive" loading="lazy" src="/myqaio/wp-content/uploads/panama-flag-icon.webp" alt="Panama flag icon."> Español</a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </header>