<?php get_header(); ?>

    <main class="page-main">

        <section class="page-content page-banner">
            <div class="banner-prev"><img class="img-responsive" src="/myqaio/wp-content/uploads/white-arrow.webp" alt="White arrow icon."></div>
            <div class="banner-next"><img class="img-responsive" src="/myqaio/wp-content/uploads/white-arrow.webp" alt="White arrow icon."></div>
            <div class="banner-slider">
                <div><img class="img-responsive left-content" fetchpriority="high" src="/myqaio/wp-content/uploads/single-sink-smart-mirror-tv.webp" alt="Modern bathroom with a smart mirror TV on a single sink."></div>
                <div><img class="img-responsive" src="/myqaio/wp-content/uploads/bathroom-double-sink-smart-mirror.webp" alt="A whole bathroom set with a double sink and a smart mirror TV."></div>
                <div><img class="img-responsive right-content" src="/myqaio/wp-content/uploads/illuminated-trifold-smart-mirror-tv-display.webp" alt="Illuminated trifold smart TV in a spacious bathroom."></div>
                <div><img class="img-responsive" src="/myqaio/wp-content/uploads/cabinet-mirror-tv-bathroom-display.webp" alt="Bathroom with a display of a cabinet smart mirror TV."></div>
                <div><img class="img-responsive" src="/myqaio/wp-content/uploads/lighted-oval-smart-mirror-tv-view.webp" alt="Lighted oval-shaped smart mirror TV bathroom display."></div>
            </div>
        </section>

        <section class="page-content global-content-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12">
                        <h1>El Espejo Inteligente que Revoluciona tu rutina matutina</h1>
                        <div class="qaio-intro-container">
                            <img class="img-responsive hidden-sm-down" loading="lazy" src="/myqaio/wp-content/uploads/illuminated-vanity-smart-mirror-tv.webp" srcset="/myqaio/wp-content/uploads/illuminated-vanity-smart-mirror-tv-768x401.webp 768w, /myqaio/wp-content/uploads/illuminated-vanity-smart-mirror-tv-1024x534.webp 1024w, /myqaio/wp-content/uploads/illuminated-vanity-smart-mirror-tv-1200x626.webp 1536w, /myqaio/wp-content/uploads/illuminated-vanity-smart-mirror-tv.webp 2048w" alt="A woman in a bathrobe admiring her reflection in a lighted mirror.">
                            <div class="qaio-intro-info">
                                <div>
                                    <p>Descubre un mundo de posibilidades con QAIO, el espejo inteligente definitivo que transforma tu baño en un oasis personalizado y de alta tecnología. Conéctate de manera fluida a todos tus dispositivos inteligentes, mantente al día con las últimas noticias, monitorea tus acciones, lee el periódico matutino o incluso mira películas, ¡todo desde la comodidad de tu baño!</p>
                                    <p>QAIO lleva la comodidad y la innovación al siguiente nivel al integrar Alexa en cada espejo, permitiéndote hacer preguntas y recibir respuestas rápidas y precisas. Además, con sus opciones de iluminación personalizables, puedes lograr la atmósfera perfecta para cualquier tarea, desde maquillarte hasta relajarte con un baño tranquilo.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12">
                        <h2>Productos QAIO</h2>
                        <div class="qaio-products-list">
                            <div class="qaio-products-item">
                                <div>
                                    <div class="qaio-product-img">
                                        <img class="img-responsive" src="/myqaio/wp-content/uploads/single-sink-bathroom-smart-mirror.webp" alt="Drawing of a bathroom showing mirror and sink.">
                                        <div class="qaio-product-opacity"><span class="popup-show" target="1">Haz clic aquí para más detalles</span></div>
                                    </div>
                                    <span class="qaio-title">Espejo Para Lavabo Individual QAIO <a href="https://evervue.com.pa/tienda/producto/espejo-qaio-para-lavabo-individual/">Comprar</a></span>
                                </div>
                            </div>
                            <div class="qaio-products-item">
                                <div>
                                    <div class="qaio-product-img">
                                        <img class="img-responsive" src="/myqaio/wp-content/uploads/double-sink-smart-mirror-illustration.webp" alt="Illustration showing a bathroom with a double sink mirror.">
                                        <div class="qaio-product-opacity"><span class="popup-show" target="2">Haz clic aquí para más detalles</span></div>
                                    </div>
                                    <span class="qaio-title">Espejo Para Lavabo Doble QAIO <a href="https://evervue.com.pa/tienda/producto/espejo-qaio-para-lavabo-doble/">Comprar</a></span>
                                </div>
                            </div>
                            <div class="qaio-products-item">
                                <div>
                                    <div class="qaio-product-img">
                                        <img class="img-responsive" src="/myqaio/wp-content/uploads/bathroom-qaio-trifold-smart-tv.webp" alt="Sketch of bathroom with a sink and a trifold smart mirror TV.">
                                        <div class="qaio-product-opacity"><span class="popup-show" target="3">Haz clic aquí para más detalles</span></div>
                                    </div>
                                    <span class="qaio-title">Espejo Tríptico QAIO <a href="https://evervue.com.pa/tienda/producto/qaio-trifold-mirror/">Comprar</a></span>
                                </div>
                            </div>
                            <div class="qaio-products-item">
                                <div>
                                    <div class="qaio-product-img">
                                        <img class="img-responsive" src="/myqaio/wp-content/uploads/cabinet-custom-smart-mirror-tv.webp" alt="A drawing of a cabinet smart mirror TV displayed above a sink.">
                                        <div class="qaio-product-opacity"><span class="popup-show" target="4">Haz clic aquí para más detalles</span></div>
                                    </div>
                                    <span class="qaio-title">Espejo de Gabinete QAIO</span>
                                </div>
                            </div>
                            <div class="qaio-products-item">
                                <div>
                                    <div class="qaio-product-img">
                                        <img class="img-responsive" src="/myqaio/wp-content/uploads/oval-smart-mirror-single-sink.webp" alt="Outline of an oval smart mirror TV with a single sink.">
                                        <div class="qaio-product-opacity"><span class="popup-show" target="5">Haz clic aquí para más detalles</span></div>
                                    </div>
                                    <span class="qaio-title">Espejo Ovalado QAIO <a href="https://evervue.com.pa/tienda/producto/espejo-ovalado-qaio/">Comprar</a></span>
                                </div>
                            </div>
                            <div class="qaio-products-item">
                                <div>
                                    <div class="qaio-product-img">
                                        <video poster="/myqaio/wp-content/uploads/custom-smart-tv-mirror-drawing.webp" playsinline="" autoplay="" loop="" muted=""><source src="/myqaio/wp-content/uploads/custom-smart-tv-mirror-drawing.mp4"></video>
                                    </div>
                                    <span class="qaio-title">Espejo Personalizado QAIO</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12">
                        <h2>Alexa toma el control de tu baño con QAIO: El Espejo Inteligente Definitivo</h2>
                        <div class="alexa-container">
                            <video class="hidden-sm-up" poster="/myqaio/wp-content/uploads/alexa-voice-assistant-smart-mirror.webp" playsinline="" autoplay="" loop="" muted=""><source src="/myqaio/wp-content/uploads/alexa-voice-assistant-smart-mirror.mp4"></video>
                            <video class="hidden-xs-down" poster="/myqaio/wp-content/uploads/voice-assistant-digital-mirror-tv.webp" playsinline="" autoplay="" loop="" muted=""><source src="/myqaio/wp-content/uploads/voice-assistant-digital-mirror-tv.mp4"></video>
                            <div class="alexa-info">
                                <h3>QAIO Luces, cámara, ¡Alexa!</h3>
                                <p class="hidden-xxs">Con Alexa integrada en cada espejo QAIO, puedes hacer preguntas sin esfuerzo, obtener respuestas instantáneas y gestionar tus tareas diarias sin salir de tu santuario en el baño.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12">
                        <h2>QAIO: Desatando todo el potencial de tus dispositivos inteligentes</h2>
                        <p>Experimenta el futuro de la tecnología en el baño con QAIO, el espejo inteligente que te permite conectar e interactuar con tus dispositivos como nunca antes. ¡Di adiós a la necesidad de un smartphone en el baño y disfruta de una integración perfecta con tu cepillo de dientes, afeitadora, báscula y más!</p>
                        <p>Con QAIO, todos los datos de tus dispositivos se muestran de manera conveniente en el espejo, lo que te permite seguir tu progreso, establecer metas y monitorear tu salud y bienestar con facilidad. La interfaz intuitiva asegura que gestionar tus dispositivos inteligentes sea muy sencillo, convirtiendo a QAIO en la adición perfecta para cualquier baño moderno.</p>
                        <p>Las imágenes y aplicaciones mostradas aquí son únicamente con el propósito de demostrar la compatibilidad de QAIO con diversos dispositivos y accesorios. El contenido, los dispositivos y los accesorios necesarios para ofrecer este contenido son suministrados por proveedores externos y terceros.</p>
                        <div class="smart-devices-container">
                            <div class="smart-devices-title hidden-md-up">
                                <span class="active" target="1">Reloj Inteligente</span>
                                <span target="2">Afeitadora</span>
                                <span target="3">Cepillo de Dientes</span>
                                <span target="4">Probador de Hidratación Facial</span>
                                <span target="5">Báscula Inteligente</span>
                                <span target="6">Monitor de Presión Arterial</span>
                            </div>
                            <div class="smart-devices-large-images">
                                <img class="img-responsive" src="/myqaio/wp-content/uploads/smart-mirror-health-app-monitor.webp" srcset="/myqaio/wp-content/uploads/smart-mirror-health-app-monitor-768x432.webp 768w, /myqaio/wp-content/uploads/smart-mirror-health-app-monitor-1200x675.webp 1536w, /myqaio/wp-content/uploads/smart-mirror-health-app-monitor.webp 2048w" alt="A bathroom smart mirror TV with a smart app that monitors blood pressure and temperature.">
                                
                                <img target="1" class="img-responsive active" src="/myqaio/wp-content/uploads/smart-mirror-health-app-monitor.webp" srcset="/myqaio/wp-content/uploads/smart-mirror-health-app-monitor-768x432.webp 768w, /myqaio/wp-content/uploads/smart-mirror-health-app-monitor-1200x675.webp 1536w, /myqaio/wp-content/uploads/smart-mirror-health-app-monitor.webp 2048w" alt="A bathroom smart mirror TV with a smart app that monitors blood pressure and temperature.">
                                <img target="2" class="img-responsive" src="/myqaio/wp-content/uploads/face-features-digital-display-tv-mirror.webp" srcset="/myqaio/wp-content/uploads/face-features-digital-display-tv-mirror-768x432.webp 768w, /myqaio/wp-content/uploads/face-features-digital-display-tv-mirror-1200x675.webp 1536w, /myqaio/wp-content/uploads/face-features-digital-display-tv-mirror.webp 2048w" alt="A bathroom mirror with a digital display showing facial features and battery percentage.">
                                <img target="3" class="img-responsive" src="/myqaio/wp-content/uploads/smart-mirror-tv-digital-teeth-health.webp" srcset="/myqaio/wp-content/uploads/smart-mirror-tv-digital-teeth-health-768x432.webp 768w, /myqaio/wp-content/uploads/smart-mirror-tv-digital-teeth-health-1200x675.webp 1536w, /myqaio/wp-content/uploads/smart-mirror-tv-digital-teeth-health.webp 2048w" alt="A smart mirror TV that has a digital screen displaying the overview of teeth health.">
                                <img target="4" class="img-responsive" src="/myqaio/wp-content/uploads/face-hydration-monitor-smart-tv.webp" srcset="/myqaio/wp-content/uploads/face-hydration-monitor-smart-tv-768x432.webp 768w, /myqaio/wp-content/uploads/face-hydration-monitor-smart-tv-1200x675.webp 1536w, /myqaio/wp-content/uploads/face-hydration-monitor-smart-tv.webp 2048w" alt="Modern bathroom mirror with built-in facial hydration monitor">
                                <img target="5" class="img-responsive" src="/myqaio/wp-content/uploads/smart-weight-scale-bathroom-mirror-tv.webp" srcset="/myqaio/wp-content/uploads/smart-weight-scale-bathroom-mirror-tv-768x432.webp 768w, /myqaio/wp-content/uploads/smart-weight-scale-bathroom-mirror-tv-1200x675.webp 1536w, /myqaio/wp-content/uploads/smart-weight-scale-bathroom-mirror-tv.webp 2048w" alt="Bathroom mirror featuring digital smart weighing scale.">
                                <img target="6" class="img-responsive" src="/myqaio/wp-content/uploads/smart-mirror-health-app-monitor.webp" srcset="/myqaio/wp-content/uploads/smart-mirror-health-app-monitor-768x432.webp 768w, /myqaio/wp-content/uploads/smart-mirror-health-app-monitor-1200x675.webp 1536w, /myqaio/wp-content/uploads/smart-mirror-health-app-monitor.webp 2048w" alt="A bathroom smart mirror TV with a smart app that monitors blood pressure and temperature.">
                            </div>
                            <div class="smart-devices-thumbnail-container">
                                <div>
                                    <div class="smart-devices-title hidden-sm-down">
                                        <span class="active" target="1">Reloj Inteligente</span>
                                        <span target="2">Afeitadora</span>
                                        <span target="3">Cepillo de Dientes</span>
                                        <span target="4">Probador de Hidratación Facial</span>
                                        <span target="5">Báscula Inteligente</span>
                                        <span target="6">Monitor de Presión Arterial</span>
                                    </div>
                                    <div class="smart-devices-thumbnail-center">
                                        <div class="smart-devices-thumbnail-grid">
                                            <div class="smart-devices-thumbnail active" target="1"><img class="img-responsive" src="/myqaio/wp-content/uploads/smart-watch-icon.webp" alt="Smart watch option icon."></div>
                                            <div class="smart-devices-thumbnail" target="2"><img class="img-responsive" src="/myqaio/wp-content/uploads/shaver-option-icon.webp" alt="Shaver option icon."></div>
                                            <div class="smart-devices-thumbnail" target="3"><img class="img-responsive" src="/myqaio/wp-content/uploads/toothbrush-option-icon.webp" alt="Toothbrush option icon."></div>
                                            <div class="smart-devices-thumbnail" target="4"><img class="img-responsive" src="/myqaio/wp-content/uploads/facial-hydration-icon.webp" alt="Facial hydration option icon."></div>
                                            <div class="smart-devices-thumbnail" target="5"><img class="img-responsive" src="/myqaio/wp-content/uploads/smart-weighing-scale-icon.webp" alt="Smart weighing scale option icon."></div>
                                            <div class="smart-devices-thumbnail" target="6"><img class="img-responsive" src="/myqaio/wp-content/uploads/blood-pressure-monitor-icon.webp" alt="Blood pressure monitor option icon."></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12">
                        <h2>El espejo inteligente apto para toda la familia, para todas las edades</h2>
                        <div class="family-friendly-container">
                            <div class="family-friendly-large-images">
                                <img class="img-responsive" src="/myqaio/wp-content/uploads/mirror-home-security-system-smart-tv.webp" srcset="/myqaio/wp-content/uploads/mirror-home-security-system-smart-tv-768x467.webp 768w, /myqaio/wp-content/uploads/mirror-home-security-system-smart-tv-1024x623.webp 1024w, /myqaio/wp-content/uploads/mirror-home-security-system-smart-tv.webp 1536w" alt="A man engaged in doorbell monitoring on a smart mirror TV.">
                                <img target="1" class="img-responsive active" src="/myqaio/wp-content/uploads/mirror-home-security-system-smart-tv.webp" srcset="/myqaio/wp-content/uploads/mirror-home-security-system-smart-tv-768x467.webp 768w, /myqaio/wp-content/uploads/mirror-home-security-system-smart-tv-1024x623.webp 1024w, /myqaio/wp-content/uploads/mirror-home-security-system-smart-tv.webp 1536w" alt="A man engaged in doorbell monitoring on a smart mirror TV.">
                                <img target="2" class="img-responsive" src="/myqaio/wp-content/uploads/smart-mirror-tv-video-display.webp" srcset="/myqaio/wp-content/uploads/smart-mirror-tv-video-display-768x489.webp 768w, /myqaio/wp-content/uploads/smart-mirror-tv-video-display-1024x652.webp 1024w, /myqaio/wp-content/uploads/smart-mirror-tv-video-display.webp 1536w" alt="A man watching a movie while looking at his reflection on a smart mirror.">
                                <img target="3" class="img-responsive" src="/myqaio/wp-content/uploads/toothbrush-app-feature-qaio-mirror-tv.webp" srcset="/myqaio/wp-content/uploads/toothbrush-app-feature-qaio-mirror-tv-768x489.webp 768w, /myqaio/wp-content/uploads/toothbrush-app-feature-qaio-mirror-tv-1024x652.webp 1024w, /myqaio/wp-content/uploads/toothbrush-app-feature-qaio-mirror-tv.webp 1536w" alt="A woman and a child brushing teeth together in front of a smart mirror TV.">
                                <img target="4" class="img-responsive" src="/myqaio/wp-content/uploads/stocks-news-display-bathroom-smart-mirror.webp" srcset="/myqaio/wp-content/uploads/stocks-news-display-bathroom-smart-mirror-768x489.webp 768w, /myqaio/wp-content/uploads/stocks-news-display-bathroom-smart-mirror-1024x652.webp 1024w, /myqaio/wp-content/uploads/stocks-news-display-bathroom-smart-mirror.webp 1536w" alt="A man fixing his tie while looking at his reflection on a digital mirror TV.">
                                <img target="5" class="img-responsive" src="/myqaio/wp-content/uploads/digital-mirror-touchscreen-control-features.webp" srcset="/myqaio/wp-content/uploads/digital-mirror-touchscreen-control-features-768x467.webp 768w, /myqaio/wp-content/uploads/digital-mirror-touchscreen-control-features-1024x623.webp 1024w, /myqaio/wp-content/uploads/digital-mirror-touchscreen-control-features.webp 1536w" alt="Touchscreen control panel that has a futuristic smart mirror showcases various icons.">
                                <img target="6" class="img-responsive" src="/myqaio/wp-content/uploads/news-display-lighted-mirror-tv.webp" srcset="/myqaio/wp-content/uploads/news-display-lighted-mirror-tv-768x489.webp 768w, /myqaio/wp-content/uploads/news-display-lighted-mirror-tv-1024x652.webp 1024w, /myqaio/wp-content/uploads/news-display-lighted-mirror-tv.webp 1536w" alt="A bathroom with a wall-mounted lighted smart mirror.">
                            </div>
                            <div class="family-friendly-thumbnail-container">
                                <div>
                                    <div class="family-friendly-desc hidden-sm-down">
                                        <p class="active" target="1">Domina tu mundo a través de tu espejo de tocador. Por ejemplo, puedes ver quién está en la puerta de tu casa mientras te cepillas los dientes en el lavabo del baño. QAIO se conecta fácilmente a Ring y otros sistemas de timbre y seguridad, para que puedas navegar por tu entorno físico con la misma facilidad con la que exploras el mundo virtual.</p>
                                        <p class="" target="2">Prepárate para ver películas en Netflix, Hulu, YouTube o Amazon. Todo lo que puedes hacer en tu teléfono, ahora tu espejo lo hará por ti, en un formato mucho más grande y con una comodidad extrema.</p>
                                        <p class="" target="3">¡A tus hijos también les encantará QAIO! Mejora sus hábitos de cepillado con las excelentes aplicaciones que puedes instalar. Haz que el tiempo de cepillado sea fácil y divertido, para que tus niños esperen con ansias la experiencia.</p>
                                        <p class="" target="4">Aparte del entretenimiento, puedes consultar tus acciones, las noticias, el clima, el tiempo de viaje al trabajo o agregar recordatorios. QAIO tiene una pantalla separada de 12.1” en la parte superior que te mantendrá informado en todo momento. Personaliza la visualización de la información para mostrar tantos datos como desees. Si la simplicidad es más tu estilo, puedes mostrar solo un reloj que flota con elegancia en el espejo. Y cuando termines, apágalo y la pantalla desaparecerá por completo.</p>
                                        <p class="" target="5">QAIO se integra fácilmente en tu hogar Control4 y otros sistemas populares de automatización del hogar. No es necesario instalar un panel adicional en tu baño para controlar tu hogar. Todo está oculto detrás de tu espejo. Descubre todas las formas en las que el espejo inteligente QAIO puede hacer tu vida más placentera, integrándose perfectamente con tu hogar.</p>
                                        <p class="" target="6">Mira televisión en vivo en QAIO. Descarga la aplicación de tu proveedor de televisión en vivo, inicia sesión y disfruta de la televisión en vivo en tu baño.</p>
                                    </div>
                                    <div class="family-friendly-thumbnail-center">
                                        <div class="family-friendly-thumbnail-grid">
                                            <div class="family-friendly-thumbnail active" target="1"><img class="img-responsive" src="/myqaio/wp-content/uploads/ring-home-security-icon.webp" alt="Ring home security icon."></div>
                                            <div class="family-friendly-thumbnail" target="2"><img class="img-responsive" src="/myqaio/wp-content/uploads/netflix-icon.webp" alt="Netflix icon."></div>
                                            <div class="family-friendly-thumbnail" target="3"><img class="img-responsive" src="/myqaio/wp-content/uploads/teeth-brushing-icon.webp" alt="Brushing teeth icon."></div>
                                            <div class="family-friendly-thumbnail" target="4"><img class="img-responsive" src="/myqaio/wp-content/uploads/digital-stock-market-icon.webp" alt="Digital stock market icon."></div>
                                            <div class="family-friendly-thumbnail" target="5"><img class="img-responsive" src="/myqaio/wp-content/uploads/digital-control-icon.webp" alt="Digital control icon."></div>
                                            <div class="family-friendly-thumbnail" target="6"><img class="img-responsive" src="/myqaio/wp-content/uploads/live-tv-icon.webp" alt="Live TV icon."></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section half-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12 col-md-8 col-md-offset-2">
                        <h2 class="text-center">Ve QAIO en acción</h2>
                        <div class="iframe-container mobile-margin">
                            <iframe src="https://www.youtube.com/embed/wNg0WezMgyc?si=g0gXUQucd3tiA1wk" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section half-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12 col-md-4">
                        <h2>QAIO True Light: La iluminación Perfecta para cada Situación</h2>
                        <p>Imagina un mundo donde puedas experimentar una iluminación impecable en cualquier entorno: ¡QAIO True Light lo hace realidad! Nuestro espejo inteligente cuenta con tiras de luz verticales que simulan diversas condiciones de iluminación para brindarte la máxima versatilidad.</p>
                        <p>Desde el cálido resplandor de la luz solar hasta el brillo fresco de las luces de oficina, desde la acogedora atmósfera del salón hasta el suave parpadeo de la luz de las velas, QAIO True Light abarca todo el espectro entre 2700K y 6300K. Esto te permite ajustar fácilmente el tono de luz perfecto para cualquier situación, asegurando que tu maquillaje luzca impecable en cualquier entorno.</p>
                    </div>
                    <div class="col-xxs-12 col-md-8">
                        <video class="mobile-margin" poster="/myqaio/wp-content/uploads/true-light-remote-control-smart-tv.webp" playsinline="" autoplay="" loop="" muted=""><source src="/myqaio/wp-content/uploads/true-light-remote-control-smart-tv.mp4"></video>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section half-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12 col-md-4">
                        <h2>Luz sin contacto: una solución higiénica y sin interrupciones para tus mañanas</h2>
                        <p>Experimenta la comodidad sin esfuerzo con la función de encendido y apagado de luz sin contacto de QAIO. Simplemente mueve tu mano debajo del espejo inteligente y la luz LED True Light se encenderá o apagará sin necesidad de contacto físico. Esta solución innovadora e higiénica es perfecta para esas mañanas ajetreadas cuando necesitas un inicio rápido y fácil.</p>
                    </div>
                    <div class="col-xxs-12 col-md-8">
                        <video class="mobile-margin" poster="/myqaio/wp-content/uploads/smart-mirror-technology-touchless-light-sensor.webp" playsinline="" autoplay="" loop="" muted=""><source src="/myqaio/wp-content/uploads/smart-mirror-technology-touchless-light-sensor.mp4"></video>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section half-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12 col-md-4">
                        <h2>Luz Nocturna: Guiando tu camino en la oscuridad</h2>
                        <p>Con la práctica función de luz nocturna de QAIO, navegar por tu baño en medio de la noche nunca ha sido tan fácil. La luz nocturna incorporada se enciende automáticamente al entrar, proporcionando una suave iluminación que guía tu camino sin interrumpir tu ciclo de sueño.</p>
                        <p>Olvídate de buscar interruptores de luz o tropezar en la oscuridad. QAIO asegura tu seguridad y comodidad, incluso durante esas visitas nocturnas. Duerme tranquilo sabiendo que QAIO estará allí para iluminar tu camino cuando lo necesites.</p>
                    </div>
                    <div class="col-xxs-12 col-md-8">
                        <img class="img-responsive mobile-margin" src="/myqaio/wp-content/uploads/night-light-smart-mirror-technology.webp" alt="A bathroom mirror with a night light feature.">
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section half-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12 col-md-4 ol-col">
                        <h2>Instalación Fácil: configuración sin complicaciones para tu espejo inteligente QAIO</h2>
                        <p>Instalar tu espejo inteligente QAIO es muy fácil, generalmente toma solo 30-40 minutos. Sigue estos simples pasos para transformar tu baño sin esfuerzo:</p>
                        <ol>
                            <li>Monta las tiras de soporte en la pared de manera segura.</li>
                            <li>Conecta el espejo inteligente QAIO a una fuente de energía.</li>
                            <li>Cuelga el espejo QAIO en las tiras de soporte de la pared.</li>
                        </ol>
                        <p>¡Eso es todo! En solo unos pocos pasos rápidos, tendrás tu espejo inteligente QAIO funcionando, listo para revolucionar tu rutina diaria.</p>
                    </div>
                    <div class="col-xxs-12 col-md-8">
                        <video class="mobile-margin" poster="/myqaio/wp-content/uploads/qaio-smarter-mirror-installation-guide.webp" playsinline="" autoplay="" loop="" muted=""><source src="/myqaio/wp-content/uploads/qaio-smarter-mirror-installation-guide.mp4"></video>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section">
            <div class="container">
                <div class="row">
                    <div class="col-xxs-12"><h2>QAIO lo tiene todo</h2></div>
                    <div class="col-xxs-12 col-md-6">
                        <div class="qhia-left-container">
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>Cámara Full HD Integrada</span>
                                    <p>Experimenta lo último en tecnología de espejos inteligentes con QAIO. Nuestro diseño de vanguardia incluye una cámara Full HD integrada y oculta para brindarte aún más comodidad y conectividad. La ubicación discreta de la cámara asegura que tu baño mantenga su apariencia elegante y moderna.</p>
                                    <p>Entendemos la importancia de la privacidad, por lo que la cámara se puede desconectar fácilmente si lo deseas. Con QAIO, puedes disfrutar de los beneficios de la tecnología avanzada mientras mantienes el control total sobre tu espacio personal.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/hd-camera-icon.webp" alt="HD camera icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>Instalación fácil en 30 minutos: Configuración rápida y sin esfuerzo</span>
                                    <p>Configurar tu espejo inteligente QAIO es increíblemente fácil y solo toma 30 minutos. Sigue estos pasos sencillos para disfrutar de tu nuevo compañero en el baño.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/tools-setup-icon.webp" alt="Settings or tools icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>Totalmente personalizable a cualquier tamaño y forma: Personaliza tu Experiencia QAIO</span>
                                    <p>QAIO está comprometido con satisfacer tus necesidades y preferencias únicas, ofreciendo no solo tamaños estándar, sino también opciones de personalización completas. Esto te permite crear un espejo inteligente en prácticamente cualquier forma y tamaño para complementar perfectamente la estética de tu baño.</p>
                                    <p>Ya sea que busques un diseño rectangular clásico o algo más creativo, QAIO tiene la flexibilidad para adaptarse a tu visión. Da vida a tu baño soñado con un espejo inteligente personalizado que mejora tanto el estilo como la funcionalidad de tu espacio.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/customizing-icon.webp" alt="Customizing icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>Control por voz Alexa: El futuro de los espejos inteligentes con QAIO</span>
                                    <p>Experimenta el poder del control por voz en tu baño con la integración de Alexa en QAIO. Simplemente haz preguntas y las respuestas aparecerán directamente en tu espejo inteligente. Con Alexa a tu disposición, QAIO está preparado para satisfacer tus necesidades actuales y adaptarse a los avances del futuro.</p>
                                    <p>Desde consultar el clima hasta establecer recordatorios, gestionar tu agenda o controlar tus dispositivos inteligentes, la integración de Alexa en QAIO hace que tu rutina diaria sea más fácil y eficiente. Abraza el futuro de la tecnología para el baño con QAIO, el espejo inteligente que combina conveniencia, estilo e innovación, todo con el poder de tu voz.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/alexa-voice-assistant-icon.webp" alt="Alexa voice assistant icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>Luz Nocturna: Guiando tu camino en la oscuridad</span>
                                    <p>Con la práctica función de luz nocturna de QAIO, navegar por tu baño en medio de la noche nunca ha sido tan fácil. La luz nocturna incorporada se enciende automáticamente al entrar, proporcionando una suave iluminación que guía tu camino sin interrumpir tu ciclo de sueño.</p>
                                    <p>Olvídate de buscar interruptores de luz o tropezar en la oscuridad. QAIO asegura tu seguridad y comodidad, incluso durante esas visitas nocturnas. Duerme tranquilo sabiendo que QAIO estará allí para iluminar tu camino cuando lo necesites.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/light-display-icon.webp" alt="Light display icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>QAIO True Light: Iluminación perfecta para cada situación</span>
                                    <p>Imagina un mundo donde puedas experimentar una iluminación impecable en cualquier entorno: ¡QAIO True Light lo hace realidad! Nuestro espejo inteligente cuenta con tiras de luz verticales que simulan diversas condiciones de iluminación para brindarte la máxima versatilidad.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/light-bulb-icon.webp" alt="Light bulb icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-left-item">
                                <div class="qhia-info">
                                    <span>Teclado inalámbrico: Desata todo el potencial de tu espejo inteligente QAIO</span>
                                    <p>Para maximizar tu experiencia con las aplicaciones de Smart TV de QAIO, el espejo viene con un teclado inalámbrico. Este accesorio fácil de usar te permite interactuar completamente con las funciones de tu espejo inteligente, facilitando la navegación, búsqueda e ingreso de información.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/keyboard-icon.webp" alt="Keyboard icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxs-12 col-md-6">
                        <div class="qhia-left-container">
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>Micrófono integrado: Garantizando compatibilidad y privacidad</span>
                                    <p>A medida que aumenta la demanda de aplicaciones que requieren micrófono, QAIO se mantiene a la vanguardia con su función de micrófono integrado. Esto garantiza compatibilidad con una amplia variedad de aplicaciones, brindándote una experiencia interactiva y fluida con tu espejo inteligente.</p>
                                    <p>En QAIO, priorizamos tu privacidad, por lo que hemos hecho posible que desconectes el micrófono siempre que lo desees.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/microphone-icon.webp" alt="Microphone icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>Elige el tamaño de TV ideal: desde 12.1" hasta 98"</span>
                                    <p>QAIO está diseñado para adaptarse a tus preferencias únicas y está disponible en una amplia gama de configuraciones y tamaños de TV. Con opciones entre 12.1″ y 98″, puedes encontrar el ajuste perfecto para tu espejo personalizado.</p>
                                    <p>Ya sea que prefieras una pantalla compacta para actualizaciones rápidas o una pantalla grande para una experiencia visual envolvente, QAIO tiene lo que necesitas. Personaliza tu espejo inteligente según tus necesidades específicas y disfruta de la comodidad y estilo incomparables que QAIO tiene para ofrecer.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/tv-size-icon.webp" alt="TV size icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>La TV desaparece por completo cuando se apaga: Experimenta la magia de QAIO</span>
                                    <p>La TV desaparece por completo cuando se apaga: Experimenta la magia de QAIO.</p>
                                    <p>Una de las características más sorprendentes de QAIO es su capacidad para hacer que la TV desaparezca cuando se apaga. ¡Es como magia! Cuando no está en uso, la TV se fusiona perfectamente con el espejo, manteniendo la apariencia elegante y moderna de tu baño.</p>
                                    <p>Este diseño innovador garantiza que tu espejo inteligente siga siendo una adición elegante y discreta a tu baño, mientras te ofrece la conveniencia y opciones de entretenimiento de un televisor integrado.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/vanishing-mirror-icon.webp" alt="Vanishing mirror icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>Completamente alimentado por 24 voltios seguros: Seguridad y versatilidad en un solo paquete</span>
                                    <p>El espejo inteligente QAIO prioriza tu seguridad, funcionando con una fuente de alimentación de 24V DC de bajo voltaje, segura para su uso en cualquier parte del baño. No necesitas preocuparte por riesgos eléctricos ni problemas de compatibilidad, ya que QAIO está diseñado para funcionar sin problemas en cualquier entorno de baño.</p>
                                    <p>Además, QAIO viene con una fuente de alimentación universal mundial, lo que garantiza que pueda instalarse y usarse fácilmente en cualquier lugar del mundo.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/volt-energy-icon.webp" alt="Volt or energy icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>Botones táctiles de encendido/apagado y volumen: Controles discretos y accesibles</span>
                                    <p>El espejo inteligente QAIO cuenta con tres botones táctiles fáciles de alcanzar para encendido/apagado y control de volumen, inteligentemente ocultos detrás del espejo. Estos controles discretos garantizan que tu espejo mantenga una apariencia elegante y moderna sin sacrificar la accesibilidad.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/power-button-icon.webp" alt="Power button icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>Pantalla táctil: Control y comodidad mejorados con QAIO</span>
                                    <p>QAIO lleva la comodidad a un nuevo nivel al ofrecer una pantalla táctil estándar en la TV principal. Esta función intuitiva te permite controlar las aplicaciones de manera mucho más rápida y eficiente que con un control remoto convencional.</p>
                                    <p>Navega fácilmente por tus aplicaciones favoritas, ajusta configuraciones y accede a una gran cantidad de información con solo tocar un dedo. La integración perfecta de la tecnología táctil con tu espejo inteligente garantiza una experiencia fácil de usar que mejora tu rutina diaria.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/touchscreen-icon.webp" alt="Touchscreen icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                            <div class="qhia-right-item">
                                <div class="qhia-info">
                                    <span>Panel adicional de 12.1": Personaliza tu centro de información con QAIO</span>
                                    <p>QAIO va más allá con su panel adicional estándar de 12.1″ ubicado en la parte superior del espejo. Esta pantalla versátil puede mostrar una variedad de información útil, como el clima local, actualizaciones de acciones, tiempos de tránsito al trabajo, recordatorios, las últimas noticias o incluso un reloj analógico tradicional.</p>
                                    <p>¿Lo mejor? Puedes configurar este panel adicional para adaptarlo a tus preferencias y necesidades, creando un centro de información personalizado que te mantendrá actualizado e informado durante todo el día.</p>
                                </div>
                                <div class="qhia-icon"><img class="img-responsive" src="/myqaio/wp-content/uploads/panel-icon.webp" alt="Panel icon."></div>
                                <div class="qhia-line"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="page-content global-content-section qaio-mirror-hospitality">
            <img class="img-responsive" src="/myqaio/wp-content/uploads/hospitality-smart-mirror-tv.webp" srcset="/myqaio/wp-content/uploads/hospitality-smart-mirror-tv-768x280.webp 768w, /myqaio/wp-content/uploads/hospitality-bathroom-smart-mirror-tv-1024x373.webp 1024w, /myqaio/wp-content/uploads/hospitality-smart-mirror-tv-1200x438.webp 1536w, /myqaio/wp-content/uploads/hospitality-smart-mirror-tv.webp 2048w" alt="Luxurious bathroom featuring a spacious tub and a lighted smart mirror TV.">
            <div class="qaio-mirror-hospitality-container container">
                <div class="qaio-mirror-hospitality-info">
                    <h2>Hospitalidad</h2>
                    <p>Con QAIO, tu hotel estará listo para las próximas décadas con características sofisticadas que impresionarán a tus huéspedes. QAIO es compatible con ProCentric y ProIdiom, por lo que la integración con tu sistema existente nunca ha sido tan fácil.</p>
                    <span class="qaio-hospitality-link">Saber más</span>
                </div>
            </div>
        </section>

    </main>

    <section class="page-content popup-section">
        <img class="popup-close" src="/myqaio/wp-content/uploads/white-close.webp" alt="Close icon.">
        <div class="popup-flex">
            <div class="popup-center">
                <img class="img-responsive popup-big" target="1" src="/myqaio/wp-content/uploads/qaio-single-sink-mirror-diagram.webp" alt="Labeled diagram of Qaio Single Sink Mirror for clear understanding.">
                <img class="img-responsive popup-big" target="2" src="/myqaio/wp-content/uploads/double-sink-smart-mirror-qaio-guide.webp" alt="Clear diagram of Qaio Double Sink Mirror for easy recognition.">
                <img class="img-responsive popup-big" target="3" src="/myqaio/wp-content/uploads/trifold-sink-mirror-tv-features.webp" alt="An image of a trifold mirror with a labeled diagram outlining its features.">
                <img class="img-responsive popup-big" target="4" src="/myqaio/wp-content/uploads/qaio-cabinet-smart-mirror-tv-label.webp" alt="Cabinet smart mirror TV descriptive features and edges.">
                <img class="img-responsive popup-big" target="5" src="/myqaio/wp-content/uploads/oval-smart-mirror-sketch-display.webp" alt="Qaio Oval Mirror diagram displaying features.">
            </div>
        </div>
    </section>

<?php get_footer(); ?>