<?php

    function dnd_cf7_mime_types( $ext ) {
        $mimes =  array(
            'ez'=>'application/andrew-inset',
            'atom'=>'application/atom+xml',
            'atomcat'=>'application/atomcat+xml',
            'atomsvc'=>'application/atomsvc+xml',
            'apxml'=>'application/auth-policy+xml',
            'ccxml'=>'application/ccxml+xml',
            'cellml'=>'application/cellml+xml',
            'cml'=>'application/cellml+xml',
            'cpl'=>'application/cpl+xml',
            'davmount'=>'application/davmount+xml',
            'dcm'=>'application/dicom',
            'dssc'=>'application/dssc+der',
            'xdssc'=>'application/dssc+xml',
            'dvc'=>'application/dvcs',
            'emma'=>'application/emma+xml',
            'finf'=>'application/fastinfoset',
            'pfr'=>'application/font-tdpfr',
            'stk'=>'application/hyperstudio',
            'ipfix'=>'application/ipfix',
            'json'=>'application/json',
            'lostxml'=>'application/lost+xml',
            'hqx'=>'application/mac-binhex40',
            'mrc'=>'application/marc',
            'nb'=>'application/mathematica',
            'ma'=>'application/mathematica',
            'mb'=>'application/mathematica',
            'mbox'=>'application/mbox',
            'm21'=>'application/mp21',
            'mp21'=>'application/mp21',
            'doc'=>'application/msword',
            'mxf'=>'application/mxf',
            'orq'=>'application/ocsp-request',
            'ors'=>'application/ocsp-response',
            'bin'=>'application/octet-stream',
            'lha'=>'application/octet-stream',
            'lzh'=>'application/octet-stream',
            'exe'=>'application/octet-stream',
            'class'=>'application/octet-stream',
            'so'=>'application/octet-stream',
            'dll'=>'application/octet-stream',
            'img'=>'application/octet-stream',
            'iso'=>'application/octet-stream',
            'oda'=>'application/oda',
            'opf'=>'application/oebps-package+xml',
            'ogx'=>'application/ogg',
            'pdf'=>'application/pdf',
            'sig'=>'application/pgp-signature',
            'p10'=>'application/pkcs10',
            'p7m'=>'application/pkcs7-mime',
            'p7c'=>'application/pkcs7-mime',
            'p7s'=>'application/pkcs7-signature',
            'cer'=>'application/pkix-cert',
            'crl'=>'application/pkix-crl',
            'pkipath'=>'application/pkix-pkipath',
            'pls'=>'application/pls+xml',
            'ai'=>'application/postscript',
            'eps'=>'application/postscript',
            'ps'=>'application/postscript',
            'cw'=>'application/prs.cww',
            'cww'=>'application/prs.cww',
            'rnd'=>'application/prs.nprend',
            'rct'=>'application/prs.nprend',
            'rdf'=>'application/rdf+xml',
            'rif'=>'application/reginfo+xml',
            'rnc'=>'application/relax-ng-compact-syntax',
            'rld'=>'application/resource-lists-diff+xml',
            'rl'=>'application/resource-lists+xml',
            'rs'=>'application/rls-services+xml',
            'rtf'=>'application/rtf',
            'scq'=>'application/scvp-cv-request',
            'scs'=>'application/scvp-cv-response',
            'spq'=>'application/scvp-vp-request',
            'spp'=>'application/scvp-vp-response',
            'sdp'=>'application/sdp',
            'soc'=>'application/sgml-open-catalog',
            'shf'=>'application/shf+xml',
            'siv'=>'application/sieve',
            'sieve'=>'application/sieve',
            'cl'=>'application/simple-filter+xml',
            'smil'=>'application/smil',
            'smi'=>'application/smil',
            'sml'=>'application/smil',
            'rq'=>'application/sparql-query',
            'srx'=>'application/sparql-results+xml',
            'gram'=>'application/srgs',
            'grxml'=>'application/srgs+xml',
            'ssml'=>'application/ssml+xml',
            'tsq'=>'application/timestamp-query',
            'tsr'=>'application/timestamp-reply',
            'plb'=>'application/vnd.3gpp.pic-bw-large',
            'psb'=>'application/vnd.3gpp.pic-bw-small',
            'pvb'=>'application/vnd.3gpp.pic-bw-var',
            'sms'=>'application/vnd.3gpp2.sms',
            'tcap'=>'application/vnd.3gpp2.tcap',
            'pwn'=>'application/vnd.3M.Post-it-Notes',
            'aso'=>'application/vnd.accpac.simply.aso',
            'imp'=>'application/vnd.accpac.simply.imp',
            'acu'=>'application/vnd.acucobol',
            'atc'=>'application/vnd.acucorp',
            'acutc'=>'application/vnd.acucorp',
            'xdp'=>'application/vnd.adobe.xdp+xml',
            'xfdf'=>'application/vnd.adobe.xfdf',
            'azf'=>'application/vnd.airzip.filesecure.azf',
            'azs'=>'application/vnd.airzip.filesecure.azs',
            'acc'=>'application/vnd.americandynamics.acc',
            'ami'=>'application/vnd.amiga.ami',
            'cii'=>'application/vnd.anser-web-certificate-issue-initiation',
            'fti'=>'application/vnd.anser-web-funds-transfer-initiation',
            'dist'=>'application/vnd.apple.installer+xml',
            'distz'=>'application/vnd.apple.installer+xml',
            'pkg'=>'application/vnd.apple.installer+xml',
            'mpkg'=>'application/vnd.apple.installer+xml',
            'm3u8'=>'application/vnd.apple.mpegurl',
            'swi'=>'application/vnd.aristanetworks.swi',
            'aep'=>'application/vnd.audiograph',
            'package'=>'application/vnd.autopackage',
            'mpm'=>'application/vnd.blueice.multipass',
            'ep'=>'application/vnd.bluetooth.ep.oob',
            'bmi'=>'application/vnd.bmi',
            'rep'=>'application/vnd.businessobjects',
            'tlclient'=>'application/vnd.cendio.thinlinc.clientconf',
            'cdxml'=>'application/vnd.chemdraw+xml',
            'mmd'=>'application/vnd.chipnuts.karaoke-mmd',
            'cdy'=>'application/vnd.cinderella',
            'cla'=>'application/vnd.claymore',
            'rp9'=>'application/vnd.cloanto.rp9',
            'c4g'=>'application/vnd.clonk.c4group',
            'c4d'=>'application/vnd.clonk.c4group',
            'c4f'=>'application/vnd.clonk.c4group',
            'c4p'=>'application/vnd.clonk.c4group',
            'c4u'=>'application/vnd.clonk.c4group',
            'ica'=>'application/vnd.commerce-battelle',
            'icf'=>'application/vnd.commerce-battelle',
            'icd'=>'application/vnd.commerce-battelle',
            'ic0'=>'application/vnd.commerce-battelle',
            'ic1'=>'application/vnd.commerce-battelle',
            'ic2'=>'application/vnd.commerce-battelle',
            'ic3'=>'application/vnd.commerce-battelle',
            'ic4'=>'application/vnd.commerce-battelle',
            'ic5'=>'application/vnd.commerce-battelle',
            'ic6'=>'application/vnd.commerce-battelle',
            'ic7'=>'application/vnd.commerce-battelle',
            'ic8'=>'application/vnd.commerce-battelle',
            'csp'=>'application/vnd.commonspace',
            'cst'=>'application/vnd.commonspace',
            'cdbcmsg'=>'application/vnd.contact.cmsg',
            'cmc'=>'application/vnd.cosmocaller',
            'clkx'=>'application/vnd.crick.clicker',
            'clkk'=>'application/vnd.crick.clicker.keyboard',
            'clkp'=>'application/vnd.crick.clicker.palette',
            'clkt'=>'application/vnd.crick.clicker.template',
            'clkw'=>'application/vnd.crick.clicker.wordbank',
            'wbs'=>'application/vnd.criticaltools.wbs+xml',
            'pml'=>'application/vnd.ctc-posml',
            'ppd'=>'application/vnd.cups-ppd',
            'curl'=>'application/vnd.curl',
            'rdz'=>'application/vnd.data-vision.rdz',
            'fe_launch'=>'application/vnd.denovo.fcselayout-link',
            'dna'=>'application/vnd.dna',
            'dpg'=>'application/vnd.dpgraph',
            'mwc'=>'application/vnd.dpgraph',
            'dpgraph'=>'application/vnd.dpgraph',
            'dfac'=>'application/vnd.dreamfactory',
            'geo'=>'application/vnd.dynageo',
            'mag'=>'application/vnd.ecowin.chart',
            'nml'=>'application/vnd.enliven',
            'esf'=>'application/vnd.epson.esf',
            'msf'=>'application/vnd.epson.msf',
            'qam'=>'application/vnd.epson.quickanime',
            'slt'=>'application/vnd.epson.salt',
            'ssf'=>'application/vnd.epson.ssf',
            'qcall'=>'application/vnd.ericsson.quickcall',
            'qca'=>'application/vnd.ericsson.quickcall',
            'es3'=>'application/vnd.eszigno3+xml',
            'et3'=>'application/vnd.eszigno3+xml',
            'ez2'=>'application/vnd.ezpix-album',
            'ez3'=>'application/vnd.ezpix-package',
            'fdf'=>'application/vnd.fdf',
            'msd'=>'application/vnd.fdsn.mseed',
            'mseed'=>'application/vnd.fdsn.mseed',
            'seed'=>'application/vnd.fsdn.seed',
            'dataless'=>'application/vnd.fsdn.seed',
            'gph'=>'application/vnd.FloGraphIt',
            'ftc'=>'application/vnd.fluxtime.clip',
            'sfd'=>'application/vnd.font-fontforge-sfd',
            'fm'=>'application/vnd.framemaker',
            'fnc'=>'application/vnd.frogans.fnc',
            'ltf'=>'application/vnd.frogans.ltf',
            'fsc'=>'application/vnd.fsc.weblaunch',
            'oas'=>'application/vnd.fujitsu.oasys',
            'oa2'=>'application/vnd.fujitsu.oasys2',
            'oa3'=>'application/vnd.fujitsu.oasys3',
            'fg5'=>'application/vnd.fujitsu.oasysgp',
            'bh2'=>'application/vnd.fujitsu.oasysprs',
            'ddd'=>'application/vnd.fujixerox.ddd',
            'xdw'=>'application/vnd.fujixerox.docuworks',
            'xbd'=>'application/vnd.fujixerox.docuworks.binder',
            'fzs'=>'application/vnd.fuzzysheet',
            'txd'=>'application/vnd.genomatix.tuxedo',
            'ggb'=>'application/vnd.geogebra.file',
            'ggt'=>'application/vnd.geogebra.tool',
            'gex'=>'application/vnd.geometry-explorer',
            'gre'=>'application/vnd.geometry-explorer',
            'gxt'=>'application/vnd.geonext',
            'g2w'=>'application/vnd.geoplan',
            'g3w'=>'application/vnd.geospace',
            'kml'=>'application/vnd.google-earth.kml+xml',
            'kmz'=>'application/vnd.google-earth.kmz',
            'gqf'=>'application/vnd.grafeq',
            'gqs'=>'application/vnd.grafeq',
            'gac'=>'application/vnd.groove-account',
            'ghf'=>'application/vnd.groove-help',
            'gim'=>'application/vnd.groove-identity-message',
            'grv'=>'application/vnd.groove-injector',
            'gtm'=>'application/vnd.groove-tool-message',
            'tpl'=>'application/vnd.groove-tool-template',
            'vcg'=>'application/vnd.groove-vcard',
            'zmm'=>'application/vnd.HandHeld-Entertainment+xml',
            'hbci'=>'application/vnd.hbci',
            'hbc'=>'application/vnd.hbci',
            'kom'=>'application/vnd.hbci',
            'upa'=>'application/vnd.hbci',
            'pkd'=>'application/vnd.hbci',
            'bpd'=>'application/vnd.hbci',
            'les'=>'application/vnd.hhe.lesson-player',
            'hpgl'=>'application/vnd.hp-HPGL',
            'hpi'=>'application/vnd.hp-hpid',
            'hpid'=>'application/vnd.hp-hpid',
            'hps'=>'application/vnd.hp-hps',
            'jlt'=>'application/vnd.hp-jlyt',
            'pcl'=>'application/vnd.hp-PCL',
            'sfd-hdstx'=>'application/vnd.hydrostatix.sof-data',
            'x3d'=>'application/vnd.hzn-3d-crossword',
            'emm'=>'application/vnd.ibm.electronic-media',
            'mpy'=>'application/vnd.ibm.MiniPay',
            'list3820'=>'application/vnd.ibm.modcap',
            'listafp'=>'application/vnd.ibm.modcap',
            'afp'=>'application/vnd.ibm.modcap',
            'pseg3820'=>'application/vnd.ibm.modcap',
            'irm'=>'application/vnd.ibm.rights-management',
            'sc'=>'application/vnd.ibm.secure-container',
            'icc'=>'application/vnd.iccprofile',
            'icm'=>'application/vnd.iccprofile',
            'igl'=>'application/vnd.igloader',
            'ivp'=>'application/vnd.immervision-ivp',
            'ivu'=>'application/vnd.immervision-ivu',
            'xpw'=>'application/vnd.intercon.formnet',
            'xpx'=>'application/vnd.intercon.formnet',
            'qbo'=>'application/vnd.intu.qbo',
            'qfx'=>'application/vnd.intu.qfx',
            'rcprofile'=>'application/vnd.ipunplugged.rcprofile',
            'irp'=>'application/vnd.irepository.package+xml',
            'xpr'=>'application/vnd.is-xpr',
            'jam'=>'application/vnd.jam',
            'rms'=>'application/vnd.jcp.javame.midlet-rms',
            'jisp'=>'application/vnd.jisp',
            'joda'=>'application/vnd.joost.joda-archive',
            'ktz'=>'application/vnd.kahootz',
            'ktr'=>'application/vnd.kahootz',
            'karbon'=>'application/vnd.kde.karbon',
            'chrt'=>'application/vnd.kde.kchart',
            'kfo'=>'application/vnd.kde.kformula',
            'flw'=>'application/vnd.kde.kivio',
            'kon'=>'application/vnd.kde.kontour',
            'kpr'=>'application/vnd.kde.kpresenter',
            'kpt'=>'application/vnd.kde.kpresenter',
            'ksp'=>'application/vnd.kde.kspread',
            'kwd'=>'application/vnd.kde.kword',
            'kwt'=>'application/vnd.kde.kword',
            'htke'=>'application/vnd.kenameaapp',
            'kia'=>'application/vnd.kidspiration',
            'kne'=>'application/vnd.Kinar',
            'knp'=>'application/vnd.Kinar',
            'sdf'=>'application/vnd.Kinar',
            'skp'=>'application/vnd.koan',
            'skd'=>'application/vnd.koan',
            'skm'=>'application/vnd.koan',
            'skt'=>'application/vnd.koan',
            'sse'=>'application/vnd.kodak-descriptor',
            'lbd'=>'application/vnd.llamagraphics.life-balance.desktop',
            'lbe'=>'application/vnd.llamagraphics.life-balance.exchange+xml',
            123=>'application/vnd.lotus-1-2-3',
            'wk4'=>'application/vnd.lotus-1-2-3',
            'wk3'=>'application/vnd.lotus-1-2-3',
            'wk1'=>'application/vnd.lotus-1-2-3',
            'apr'=>'application/vnd.lotus-approach',
            'vew'=>'application/vnd.lotus-approach',
            'prz'=>'application/vnd.lotus-freelance',
            'pre'=>'application/vnd.lotus-freelance',
            'nsf'=>'application/vnd.lotus-notes',
            'ntf'=>'application/vnd.lotus-notes',
            'ndl'=>'application/vnd.lotus-notes',
            'ns4'=>'application/vnd.lotus-notes',
            'ns3'=>'application/vnd.lotus-notes',
            'ns2'=>'application/vnd.lotus-notes',
            'nsh'=>'application/vnd.lotus-notes',
            'nsg'=>'application/vnd.lotus-notes',
            'or3'=>'application/vnd.lotus-organizer',
            'or2'=>'application/vnd.lotus-organizer',
            'org'=>'application/vnd.lotus-organizer',
            'scm'=>'application/vnd.lotus-screencam',
            'lwp'=>'application/vnd.lotus-wordpro',
            'sam'=>'application/vnd.lotus-wordpro',
            'portpkg'=>'application/vnd.macports.portpkg',
            'mdc'=>'application/vnd.marlin.drm.mdcf',
            'mcd'=>'application/vnd.mcd',
            'mc1'=>'application/vnd.medcalcdata',
            'cdkey'=>'application/vnd.mediastation.cdkey',
            'mwf'=>'application/vnd.MFER',
            'mfm'=>'application/vnd.mfmp',
            'flo'=>'application/vnd.micrografx.flo',
            'igx'=>'application/vnd.micrografx.igx',
            'mif'=>'application/vnd.mif',
            'daf'=>'application/vnd.Mobius.DAF',
            'dis'=>'application/vnd.Mobius.DIS',
            'mbk'=>'application/vnd.Mobius.MBK',
            'mqy'=>'application/vnd.Mobius.MQY',
            'msl'=>'application/vnd.Mobius.MSL',
            'plc'=>'application/vnd.Mobius.PLC',
            'txf'=>'application/vnd.Mobius.TXF',
            'mpn'=>'application/vnd.mophun.application',
            'mpc'=>'application/vnd.mophun.certificate',
            'xul'=>'application/vnd.mozilla.xul+xml',
            'cil'=>'application/vnd.ms-artgalry',
            'asf'=>'application/vnd.ms-asf',
            'cab'=>'application/vnd.ms-cab-compressed',
            'xls'=>'application/vnd.ms-excel',
            'eot'=>'application/vnd.ms-fontobject',
            'chm'=>'application/vnd.ms-htmlhelp',
            'ims'=>'application/vnd.ms-ims',
            'lrm'=>'application/vnd.ms-lrm',
            'ppt'=>'application/vnd.ms-powerpoint',
            'mpp'=>'application/vnd.ms-project',
            'tnef'=>'application/vnd.ms-tnef',
            'tnf'=>'application/vnd.ms-tnef',
            'wcm'=>'application/vnd.ms-works',
            'wdb'=>'application/vnd.ms-works',
            'wks'=>'application/vnd.ms-works',
            'wps'=>'application/vnd.ms-works',
            'wpl'=>'application/vnd.ms-wpl',
            'xps'=>'application/vnd.ms-xpsdocument',
            'mseq'=>'application/vnd.mseq',
            'crtr'=>'application/vnd.multiad.creator',
            'cif'=>'application/vnd.multiad.creator.cif',
            'mus'=>'application/vnd.musician',
            'msty'=>'application/vnd.muvee.style',
            'entity'=>'application/vnd.nervana',
            'request'=>'application/vnd.nervana',
            'bkm'=>'application/vnd.nervana',
            'kcm'=>'application/vnd.nervana',
            'nlu'=>'application/vnd.neurolanguage.nlu',
            'nnd'=>'application/vnd.noblenet-directory',
            'nns'=>'application/vnd.noblenet-sealer',
            'nnw'=>'application/vnd.noblenet-web',
            'ac'=>'application/vnd.nokia.n-gage.ac+xml',
            'ngdat'=>'application/vnd.nokia.n-gage.data',
            'n-gage'=>'application/vnd.nokia.n-gage.symbian.install',
            'rpst'=>'application/vnd.nokia.radio-preset',
            'rpss'=>'application/vnd.nokia.radio-presets',
            'edm'=>'application/vnd.novadigm.EDM',
            'edx'=>'application/vnd.novadigm.EDX',
            'ext'=>'application/vnd.novadigm.EXT',
            'odc'=>'application/vnd.oasis.opendocument.chart',
            'otc'=>'application/vnd.oasis.opendocument.chart-template',
            'odb'=>'application/vnd.oasis.opendocument.database',
            'odf'=>'application/vnd.oasis.opendocument.formula',
            'otf'=>'application/vnd.oasis.opendocument.formula-template',
            'odg'=>'application/vnd.oasis.opendocument.graphics',
            'otg'=>'application/vnd.oasis.opendocument.graphics-template',
            'odi'=>'application/vnd.oasis.opendocument.image',
            'oti'=>'application/vnd.oasis.opendocument.image-template',
            'odp'=>'application/vnd.oasis.opendocument.presentation',
            'otp'=>'application/vnd.oasis.opendocument.presentation-template',
            'ods'=>'application/vnd.oasis.opendocument.spreadsheet',
            'ots'=>'application/vnd.oasis.opendocument.spreadsheet-template',
            'odt'=>'application/vnd.oasis.opendocument.text',
            'odm'=>'application/vnd.oasis.opendocument.text-master',
            'ott'=>'application/vnd.oasis.opendocument.text-template',
            'oth'=>'application/vnd.oasis.opendocument.text-web',
            'xo'=>'application/vnd.olpc-sugar',
            'dd2'=>'application/vnd.oma.dd2+xml',
            'oxt'=>'application/vnd.openofficeorg.extension',
            'ndc'=>'application/vnd.osa.netdeploy',
            'dp'=>'application/vnd.osgi.dp',
            'prc'=>'application/vnd.palm',
            'pdb'=>'application/vnd.palm',
            'pqa'=>'application/vnd.palm',
            'oprc'=>'application/vnd.palm',
            'str'=>'application/vnd.pg.format',
            'ei6'=>'application/vnd.pg.osasli',
            'pil'=>'application/vnd.piaccess.application-license',
            'efif'=>'application/vnd.picsel',
            'plf'=>'application/vnd.pocketlearn',
            'pbd'=>'application/vnd.powerbuilder6',
            'preminet'=>'application/vnd.preminet',
            'box'=>'application/vnd.previewsystems.box',
            'vbox'=>'application/vnd.previewsystems.box',
            'mgz'=>'application/vnd.proteus.magazine',
            'qps'=>'application/vnd.publishare-delta-tree',
            'ptid'=>'application/vnd.pvi.ptid1',
            'bar'=>'application/vnd.qualcomm.brew-app-res',
            'qxd'=>'application/vnd.Quark.QuarkXPress',
            'qxt'=>'application/vnd.Quark.QuarkXPress',
            'qwd'=>'application/vnd.Quark.QuarkXPress',
            'qwt'=>'application/vnd.Quark.QuarkXPress',
            'qxl'=>'application/vnd.Quark.QuarkXPress',
            'qxb'=>'application/vnd.Quark.QuarkXPress',
            'bed'=>'application/vnd.realvnc.bed',
            'mxl'=>'application/vnd.recordare.musicxml',
            'link66'=>'application/vnd.route66.link66+xml',
            'st'=>'application/vnd.sailingtracker.track',
            'scd'=>'application/vnd.scribus',
            'sla'=>'application/vnd.scribus',
            'slaz'=>'application/vnd.scribus',
            's3df'=>'application/vnd.sealed.3df',
            'scsf'=>'application/vnd.sealed.csf',
            'sdoc'=>'application/vnd.sealed.doc',
            'sdo'=>'application/vnd.sealed.doc',
            's1w'=>'application/vnd.sealed.doc',
            'seml'=>'application/vnd.sealed.eml',
            'sem'=>'application/vnd.sealed.eml',
            'smht'=>'application/vnd.sealed.mht',
            'smh'=>'application/vnd.sealed.mht',
            'sppt'=>'application/vnd.sealed.ppt',
            's1p'=>'application/vnd.sealed.ppt',
            'stif'=>'application/vnd.sealed.tiff',
            'sxls'=>'application/vnd.sealed.xls',
            'sxl'=>'application/vnd.sealed.xls',
            's1e'=>'application/vnd.sealed.xls',
            'stml'=>'application/vnd.sealedmedia.softseal.html',
            's1h'=>'application/vnd.sealedmedia.softseal.html',
            'spdf'=>'application/vnd.sealedmedia.softseal.pdf',
            'spd'=>'application/vnd.sealedmedia.softseal.pdf',
            's1a'=>'application/vnd.sealedmedia.softseal.pdf',
            'see'=>'application/vnd.seemail',
            'sema'=>'application/vnd.sema',
            'semd'=>'application/vnd.semd',
            'semf'=>'application/vnd.semf',
            'ifm'=>'application/vnd.shana.informed.formdata',
            'itp'=>'application/vnd.shana.informed.formtemplate',
            'iif'=>'application/vnd.shana.informed.interchange',
            'ipk'=>'application/vnd.shana.informed.package',
            'twd'=>'application/vnd.SimTech-MindMapper',
            'twds'=>'application/vnd.SimTech-MindMapper',
            'mmf'=>'application/vnd.smaf',
            'teacher'=>'application/vnd.smart.teacher',
            'fo'=>'application/vnd.software602.filler.form+xml',
            'zfo'=>'application/vnd.software602.filler.form-xml-zip',
            'sdkm'=>'application/vnd.solent.sdkm+xml',
            'sdkd'=>'application/vnd.solent.sdkm+xml',
            'dxp'=>'application/vnd.spotfire.dxp',
            'sfs'=>'application/vnd.spotfire.sfs',
            'wadl'=>'application/vnd.sun.wadl+xml',
            'sus'=>'application/vnd.sus-calendar',
            'susp'=>'application/vnd.sus-calendar',
            'bdm'=>'application/vnd.syncml.dm+wbxml',
            'xdm'=>'application/vnd.syncml.dm+xml',
            'xsm'=>'application/vnd.syncml+xml',
            'tao'=>'application/vnd.tao.intent-module-archive',
            'tmo'=>'application/vnd.tmobile-livetv',
            'tpt'=>'application/vnd.trid.tpt',
            'mxs'=>'application/vnd.triscape.mxs',
            'tra'=>'application/vnd.trueapp',
            'ufdl'=>'application/vnd.ufdl',
            'ufd'=>'application/vnd.ufdl',
            'frm'=>'application/vnd.ufdl',
            'utz'=>'application/vnd.uiq.theme',
            'umj'=>'application/vnd.umajin',
            'unityweb'=>'application/vnd.unity',
            'uoml'=>'application/vnd.uoml+xml',
            'uo'=>'application/vnd.uoml+xml',
            'vcx'=>'application/vnd.vcx',
            'mxi'=>'application/vnd.vd-study',
            'study-inter'=>'application/vnd.vd-study',
            'model-inter'=>'application/vnd.vd-study',
            'vwx'=>'application/vnd.vectorworks',
            'vsc'=>'application/vnd.vidsoft.vidconference',
            'vsd'=>'application/vnd.visio',
            'vst'=>'application/vnd.visio',
            'vsw'=>'application/vnd.visio',
            'vss'=>'application/vnd.visio',
            'vis'=>'application/vnd.visionary',
            'vsf'=>'application/vnd.vsf',
            'sic'=>'application/vnd.wap.sic',
            'slc'=>'application/vnd.wap.slc',
            'wbxml'=>'application/vnd.wap.wbxml',
            'wmlc'=>'application/vnd.wap.wmlc',
            'wmlsc'=>'application/vnd.wap.wmlscriptc',
            'wtb'=>'application/vnd.webturbo',
            'wsc'=>'application/vnd.wfa.wsc',
            'wmc'=>'application/vnd.wmc',
            'm'=>'application/vnd.wolfram.mathematica.package',
            'nbp'=>'application/vnd.wolfram.player',
            'wpd'=>'application/vnd.wordperfect',
            'wqd'=>'application/vnd.wqd',
            'stf'=>'application/vnd.wt.stf',
            'wv'=>'application/vnd.wv.csp+wbxml',
            'xar'=>'application/vnd.xara',
            'xfdl'=>'application/vnd.xfdl',
            'xfd'=>'application/vnd.xfdl',
            'cpkg'=>'application/vnd.xmpie.cpkg',
            'dpkg'=>'application/vnd.xmpie.dpkg',
            'ppkg'=>'application/vnd.xmpie.ppkg',
            'xlim'=>'application/vnd.xmpie.xlim',
            'hvd'=>'application/vnd.yamaha.hv-dic',
            'hvs'=>'application/vnd.yamaha.hv-script',
            'hvp'=>'application/vnd.yamaha.hv-voice',
            'osf'=>'application/vnd.yamaha.openscoreformat',
            'saf'=>'application/vnd.yamaha.smaf-audio',
            'spf'=>'application/vnd.yamaha.smaf-phrase',
            'cmp'=>'application/vnd.yellowriver-custom-menu',
            'zir'=>'application/vnd.zul',
            'zirz'=>'application/vnd.zul',
            'zaz'=>'application/vnd.zzazz.deck+xml',
            'vxml'=>'application/voicexml+xml',
            'wif'=>'application/watcherinfo+xml',
            'wsdl'=>'application/wsdl+xml',
            'wspolicy'=>'application/wspolicy+xml',
            'xav'=>'application/xcap-att+xml',
            'xca'=>'application/xcap-caps+xml',
            'xel'=>'application/xcap-el+xml',
            'xer'=>'application/xcap-error+xml',
            'xns'=>'application/xcap-ns+xml',
            'xhtml'=>'application/xhtml+xml',
            'xhtm'=>'application/xhtml+xml',
            'xht'=>'application/xhtml+xml',
            'dtd'=>'application/xml-dtd',
            'xop'=>'application/xop+xml',
            'xsl'=>'application/xslt+xml',
            'xslt'=>'application/xslt+xml',
            'mxml'=>'application/xv+xml',
            'xhvml'=>'application/xv+xml',
            'xvml'=>'application/xv+xml',
            'xvm'=>'application/xv+xml',
            'zip'=>'application/zip',
            726=>'audio/32kadpcm',
            'ac3'=>'audio/ac3',
            'amr'=>'audio/AMR',
            'awb'=>'audio/AMR-WB',
            'aal'=>'audio/ATRAC-ADVANCED-LOSSLESS',
            'atx'=>'audio/ATRAC-X',
            'at3'=>'audio/ATRAC3',
            'aa3'=>'audio/ATRAC3',
            'omg'=>'audio/ATRAC3',
            'au'=>'audio/basic',
            'snd'=>'audio/basic',
            'dls'=>'audio/dls',
            'evc'=>'audio/EVRC',
            'evb'=>'audio/EVRCB',
            'evw'=>'audio/EVRCWB',
            'lbc'=>'audio/iLBC',
            'l16'=>'audio/L16',
            'mxmf'=>'audio/mobile-xmf',
            'mpga'=>'audio/mpeg',
            'mp1'=>'audio/mpeg',
            'mp2'=>'audio/mpeg',
            'mp3'=>'audio/mpeg',
            'oga'=>'audio/ogg',
            'ogg'=>'audio/ogg',
            'spx'=>'audio/ogg',
            'sid'=>'audio/prs.sid',
            'psid'=>'audio/prs.sid',
            'qcp'=>'audio/qcelp',
            'smv'=>'audio/SMV',
            'koz'=>'audio/vnd.audikoz',
            'eol'=>'audio/vnd.digital-winds',
            'mlp'=>'audio/vnd.dolby.mlp',
            'dts'=>'audio/vnd.dts',
            'dtshd'=>'audio/vnd.dts.hd',
            'plj'=>'audio/vnd.everad.plj',
            'lvp'=>'audio/vnd.lucent.voice',
            'pya'=>'audio/vnd.ms-playready.media.pya',
            'vbk'=>'audio/vnd.nortel.vbk',
            'ecelp4800'=>'audio/vnd.nuera.ecelp4800',
            'ecelp7470'=>'audio/vnd.nuera.ecelp7470',
            'ecelp9600'=>'audio/vnd.nuera.ecelp9600',
            'smp3'=>'audio/vnd.sealedmedia.softseal.mpeg',
            'smp'=>'audio/vnd.sealedmedia.softseal.mpeg',
            's1m'=>'audio/vnd.sealedmedia.softseal.mpeg',
            'fits'=>'image/fits',
            'fit'=>'image/fits',
            'fts'=>'image/fits',
            'gif'=>'image/gif',
            'ief'=>'image/ief',
            'jp2'=>'image/jp2',
            'jpg2'=>'image/jp2',
            'jpeg'=>'image/jpeg',
            'jpg'=>'image/jpeg',
            'jpe'=>'image/jpeg',
            'jfif'=>'image/jpeg',
            'jpm'=>'image/jpm',
            'jpgm'=>'image/jpm',
            'jpx'=>'image/jpx',
            'jpf'=>'image/jpx',
            'png'=>'image/png',
            'btif'=>'image/prs.btif',
            'btf'=>'image/prs.btif',
            'pti'=>'image/prs.pti',
            't38'=>'image/t38',
            'tiff'=>'image/tiff',
            'tif'=>'image/tiff',
            'tfx'=>'image/tiff-fx',
            'psd'=>'image/vnd.adobe.photoshop',
            'djvu'=>'image/vnd.djvu',
            'djv'=>'image/vnd.djvu',
            'dxf'=>'image/vnd.dxf',
            'fbs'=>'image/vnd.fastbidsheet',
            'fpx'=>'image/vnd.fpx',
            'fst'=>'image/vnd.fst',
            'mmr'=>'image/vnd.fujixerox.edmics-mmr',
            'rlc'=>'image/vnd.fujixerox.edmics-rlc',
            'pgb'=>'image/vnd.globalgraphics.pgb',
            'ico'=>'image/vnd.microsoft.icon',
            'mdi'=>'image/vnd.ms-modi',
            'hdr'=>'image/vnd.radiance',
            'rgbe'=>'image/vnd.radiance',
            'xyze'=>'image/vnd.radiance',
            'spng'=>'image/vnd.sealed.png',
            'spn'=>'image/vnd.sealed.png',
            's1n'=>'image/vnd.sealed.png',
            'sgif'=>'image/vnd.sealedmedia.softseal.gif',
            'sgi'=>'image/vnd.sealedmedia.softseal.gif',
            's1g'=>'image/vnd.sealedmedia.softseal.gif',
            'sjpg'=>'image/vnd.sealedmedia.softseal.jpg',
            'sjp'=>'image/vnd.sealedmedia.softseal.jpg',
            's1j'=>'image/vnd.sealedmedia.softseal.jpg',
            'wbmp'=>'image/vnd.wap.wbmp',
            'xif'=>'image/vnd.xiff',
            'u8msg'=>'message/global',
            'u8dsn'=>'message/global-delivery-status',
            'u8mdn'=>'message/global-disposition-notification',
            'u8hdr'=>'message/global-headers',
            'eml'=>'message/rfc822',
            'mail'=>'message/rfc822',
            'art'=>'message/rfc822',
            'igs'=>'model/iges',
            'iges'=>'model/iges',
            'msh'=>'model/mesh',
            'mesh'=>'model/mesh',
            'silo'=>'model/mesh',
            'dwf'=>'model/vnd.dwf',
            'gdl'=>'model/vnd.gdl',
            'gsm'=>'model/vnd.gdl',
            'win'=>'model/vnd.gdl',
            'dor'=>'model/vnd.gdl',
            'lmp'=>'model/vnd.gdl',
            'rsm'=>'model/vnd.gdl',
            'msm'=>'model/vnd.gdl',
            'ism'=>'model/vnd.gdl',
            'gtw'=>'model/vnd.gtw',
            'moml'=>'model/vnd.moml+xml',
            'mts'=>'model/vnd.mts',
            'x_b'=>'model/vnd.parasolid.transmit.binary',
            'xmt_bin'=>'model/vnd.parasolid.transmit.binary',
            'x_t'=>'model/vnd.parasolid.transmit.text',
            'xmt_txt'=>'model/vnd.parasolid.transmit.text',
            'vtu'=>'model/vnd.vtu',
            'wrl'=>'model/vrml',
            'vrml'=>'model/vrml',
            'vpm'=>'multipart/voice-message',
            'ics'=>'text/calendar',
            'ifb'=>'text/calendar',
            'css'=>'text/css',
            'csv'=>'text/csv',
            'soa'=>'text/dns',
            'zone'=>'text/dns',
            'html'=>'text/html',
            'htm'=>'text/html',
            'js'=>'text/javascript',
            'asc'=>'text/plain',
            'txt'=>'text/plain',
            'text'=>'text/plain',
            'pm'=>'text/plain',
            'el'=>'text/plain',
            'c'=>'text/plain',
            'h'=>'text/plain',
            'cc'=>'text/plain',
            'hh'=>'text/plain',
            'cxx'=>'text/plain',
            'hxx'=>'text/plain',
            'f90'=>'text/plain',
            'rst'=>'text/prs.fallenstein.rst',
            'tag'=>'text/prs.lines.tag',
            'dsc'=>'text/prs.lines.tag',
            'rtx'=>'text/richtext',
            'sgml'=>'text/sgml',
            'sgm'=>'text/sgml',
            'tsv'=>'text/tab-separated-values',
            'uris'=>'text/uri-list',
            'uri'=>'text/uri-list',
            'abc'=>'text/vnd.abc',
            'dms'=>'text/vnd.DMClientScript',
            'jtd'=>'text/vnd.esmertec.theme-descriptor',
            'fly'=>'text/vnd.fly',
            'flx'=>'text/vnd.fmi.flexstor',
            'gv'=>'text/vnd.graphviz',
            'dot'=>'text/vnd.graphviz',
            '3dml'=>'text/vnd.in3d.3dml',
            '3dm'=>'text/vnd.in3d.3dml',
            'spot'=>'text/vnd.in3d.spot',
            'spo'=>'text/vnd.in3d.spot',
            'mpf'=>'text/vnd.ms-mediapackage',
            'ccc'=>'text/vnd.net2phone.commcenter.command',
            'uric'=>'text/vnd.si.uricatalogue',
            'jad'=>'text/vnd.sun.j2me.app-descriptor',
            'ts'=>'text/vnd.trolltech.linguist',
            'si'=>'text/vnd.wap.si',
            'sl'=>'text/vnd.wap.sl',
            'wml'=>'text/vnd.wap.wml',
            'wmls'=>'text/vnd.wap.wmlscript',
            'xml'=>'text/xml',
            'ent'=>'text/xml-external-parsed-entity',
            '3gp'=>'video/3gpp',
            '3gpp'=>'video/3gpp',
            '3g2'=>'video/3gpp2',
            '3gpp2'=>'video/3gpp2',
            'mj2'=>'video/mj2',
            'mjp2'=>'video/mj2',
            'mp4'=>'video/mp4',
            'mpg4'=>'video/mp4',
            'mpeg'=>'video/mpeg',
            'mpg'=>'video/mpeg',
            'mpe'=>'video/mpeg',
            'ogv'=>'video/ogg',
            'qt'=>'video/quicktime',
            'mov'=>'video/quicktime',
            'fvt'=>'video/vnd.fvt',
            'mxu'=>'video/vnd.mpegurl',
            'm4u'=>'video/vnd.mpegurl',
            'pyv'=>'video/vnd.ms-playready.media.pyv',
            'nim'=>'video/vnd.nokia.interleaved-multimedia',
            'smpg'=>'video/vnd.sealed.mpeg1',
            's11'=>'video/vnd.sealed.mpeg1',
            's14'=>'video/vnd.sealed.mpeg4',
            'sswf'=>'video/vnd.sealed.swf',
            'ssw'=>'video/vnd.sealed.swf',
            'smov'=>'video/vnd.sealedmedia.softseal.mov',
            'smo'=>'video/vnd.sealedmedia.softseal.mov',
            's1q'=>'video/vnd.sealedmedia.softseal.mov',
            'cpt'=>'application/mac-compactpro',
            'mml'=>'application/mathml+xml',
            'metalink'=>'application/metalink+xml',
            'rss'=>'application/rss+xml',
            'xlam'=>'application/vnd.ms-excel.addin.macroEnabled.12',
            'xlsb'=>'application/vnd.ms-excel.sheet.binary.macroEnabled.12',
            'xlsm'=>'application/vnd.ms-excel.sheet.macroEnabled.12',
            'xltm'=>'application/vnd.ms-excel.template.macroEnabled.12',
            'ppam'=>'application/vnd.ms-powerpoint.addin.macroEnabled.12',
            'pptm'=>'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
            'sldm'=>'application/vnd.ms-powerpoint.slide.macroEnabled.12',
            'ppsm'=>'application/vnd.ms-powerpoint.slideshow.macroEnabled.12',
            'potm'=>'application/vnd.ms-powerpoint.template.macroEnabled.12',
            'docm'=>'application/vnd.ms-word.document.macroEnabled.12',
            'dotm'=>'application/vnd.ms-word.template.macroEnabled.12',
            'dd'=>'application/vnd.oma.dd+xml',
            'dcf'=>'application/vnd.oma.drm.content',
            'o4a'=>'application/vnd.oma.drm.dcf',
            'o4v'=>'application/vnd.oma.drm.dcf',
            'dm'=>'application/vnd.oma.drm.message',
            'drc'=>'application/vnd.oma.drm.rights+wbxml',
            'dr'=>'application/vnd.oma.drm.rights+xml',
            'pptx'=>'application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'sldx'=>'application/vnd.openxmlformats-officedocument.presentationml.slide',
            'ppsx'=>'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
            'potx'=>'application/vnd.openxmlformats-officedocument.presentationml.template',
            'xlsx'=>'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'xltx'=>'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
            'docx'=>'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'dotx'=>'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
            'sxc'=>'application/vnd.sun.xml.calc',
            'stc'=>'application/vnd.sun.xml.calc.template',
            'sxd'=>'application/vnd.sun.xml.draw',
            'std'=>'application/vnd.sun.xml.draw.template',
            'sxi'=>'application/vnd.sun.xml.impress',
            'sti'=>'application/vnd.sun.xml.impress.template',
            'sxm'=>'application/vnd.sun.xml.math',
            'sxw'=>'application/vnd.sun.xml.writer',
            'sxg'=>'application/vnd.sun.xml.writer.global',
            'stw'=>'application/vnd.sun.xml.writer.template',
            'sis'=>'application/vnd.symbian.install',
            'mms'=>'application/vnd.wap.mms-message',
            'bcpio'=>'application/x-bcpio',
            'torrent'=>'application/x-bittorrent',
            'bz2'=>'application/x-bzip2',
            'vcd'=>'application/x-cdlink',
            'pgn'=>'application/x-chess-pgn',
            'cpio'=>'application/x-cpio',
            'csh'=>'application/x-csh',
            'dcr'=>'application/x-director',
            'dir'=>'application/x-director',
            'dxr'=>'application/x-director',
            'dvi'=>'application/x-dvi',
            'spl'=>'application/x-futuresplash',
            'gtar'=>'application/x-gtar',
            'gz'=>'application/x-gzip',
            'tgz'=>'application/x-gzip',
            'hdf'=>'application/x-hdf',
            'jar'=>'application/x-java-archive',
            'jnlp'=>'application/x-java-jnlp-file',
            'pack'=>'application/x-java-pack200',
            'kil'=>'application/x-killustrator',
            'latex'=>'application/x-latex',
            'nc'=>'application/x-netcdf',
            'cdf'=>'application/x-netcdf',
            'pl'=>'application/x-perl',
            'rpm'=>'application/x-rpm',
            'sh'=>'application/x-sh',
            'shar'=>'application/x-shar',
            'swf'=>'application/x-shockwave-flash',
            'sit'=>'application/x-stuffit',
            'sv4cpio'=>'application/x-sv4cpio',
            'sv4crc'=>'application/x-sv4crc',
            'tar'=>'application/x-tar',
            'tcl'=>'application/x-tcl',
            'tex'=>'application/x-tex',
            'texinfo'=>'application/x-texinfo',
            'texi'=>'application/x-texinfo',
            't'=>'application/x-troff',
            'tr'=>'application/x-troff',
            'roff'=>'application/x-troff',
            'man'=>'application/x-troff-man',
            1=>'application/x-troff-man',
            2=>'application/x-troff-man',
            3=>'application/x-troff-man',
            4=>'application/x-troff-man',
            5=>'application/x-troff-man',
            6=>'application/x-troff-man',
            7=>'application/x-troff-man',
            8=>'application/x-troff-man',
            'me'=>'application/x-troff-me',
            'ms'=>'application/x-troff-ms',
            'ustar'=>'application/x-ustar',
            'src'=>'application/x-wais-source',
            'xz'=>'application/x-xz',
            'mid'=>'audio/midi',
            'midi'=>'audio/midi',
            'kar'=>'audio/midi',
            'aif'=>'audio/x-aiff',
            'aiff'=>'audio/x-aiff',
            'aifc'=>'audio/x-aiff',
            'mod'=>'audio/x-mod',
            'ult'=>'audio/x-mod',
            'uni'=>'audio/x-mod',
            'm15'=>'audio/x-mod',
            'mtm'=>'audio/x-mod',
            669=>'audio/x-mod',
            'med'=>'audio/x-mod',
            'm3u'=>'audio/x-mpegurl',
            'wax'=>'audio/x-ms-wax',
            'wma'=>'audio/x-ms-wma',
            'ram'=>'audio/x-pn-realaudio',
            'rm'=>'audio/x-pn-realaudio',
            'ra'=>'audio/x-realaudio',
            's3m'=>'audio/x-s3m',
            'stm'=>'audio/x-stm',
            'wav'=>'audio/x-wav',
            'xyz'=>'chemical/x-xyz',
            'bmp'=>'image/bmp',
            'svg'=>'image/svg+xml',
            'svgz'=>'image/svg+xml',
            'ras'=>'image/x-cmu-raster',
            'pnm'=>'image/x-portable-anymap',
            'pbm'=>'image/x-portable-bitmap',
            'pgm'=>'image/x-portable-graymap',
            'ppm'=>'image/x-portable-pixmap',
            'rgb'=>'image/x-rgb',
            'tga'=>'image/x-targa',
            'xbm'=>'image/x-xbitmap',
            'xpm'=>'image/x-xpixmap',
            'xwd'=>'image/x-xwindowdump',
            'manifest'=>'text/cache-manifest',
            'pod'=>'text/x-pod',
            'etx'=>'text/x-setext',
            'vcf'=>'text/x-vcard',
            'webm'=>'video/webm',
            'flv'=>'video/x-flv',
            'asx'=>'video/x-ms-asf',
            'wm'=>'video/x-ms-wm',
            'wmv'=>'video/x-ms-wmv',
            'wmx'=>'video/x-ms-wmx',
            'wvx'=>'video/x-ms-wvx',
            'avi'=>'video/x-msvideo',
            'movie'=>'video/x-sgi-movie',
            'ice'=>'x-conference/x-cooltalk',
            'sisx'=>'x-epoc/x-sisx-app',
        );

        $mimes = apply_filters('dnd_cf7_mime_types', $mimes );

        if( isset( $mimes[ $ext ] ) ){
            return $mimes[ $ext ];
        }

        return $mimes;
    }
?>